/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;

public abstract class Streams {
    public static final int BUFFER_SIZE = 8192;
    public static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }
    };

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return Streams.copy(in, out, new byte[8192]);
    }

    public static long copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        Objects.requireNonNull(in, "No InputStream specified");
        Objects.requireNonNull(out, "No OutputStream specified");
        try (InputStream in2 = in;){
            long l;
            block12: {
                OutputStream out2 = out;
                try {
                    l = Streams.doCopy(in2, out2, buffer);
                    if (out2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (out2 != null) {
                        try {
                            out2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                out2.close();
            }
            return l;
        }
    }

    private static long doCopy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int bytesRead;
        long byteCount = 0L;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            byteCount += (long)bytesRead;
        }
        out.flush();
        return byteCount;
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        Objects.requireNonNull(in, "No input byte array specified");
        Objects.requireNonNull(out, "No OutputStream specified");
        try (OutputStream out2 = out;){
            out2.write(in);
        }
    }

    public static int copy(Reader in, Writer out) throws IOException {
        Objects.requireNonNull(in, "No Reader specified");
        Objects.requireNonNull(out, "No Writer specified");
        try (Reader in2 = in;){
            int n;
            block12: {
                Writer out2 = out;
                try {
                    n = Streams.doCopy(in2, out2);
                    if (out2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (out2 != null) {
                        try {
                            out2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                out2.close();
            }
            return n;
        }
    }

    private static int doCopy(Reader in, Writer out) throws IOException {
        int bytesRead;
        int byteCount = 0;
        char[] buffer = new char[8192];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        out.flush();
        return byteCount;
    }

    public static void copy(String in, Writer out) throws IOException {
        Objects.requireNonNull(in, "No input String specified");
        Objects.requireNonNull(out, "No Writer specified");
        try (Writer out2 = out;){
            out2.write(in);
        }
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        Streams.copy(in, (Writer)out);
        return out.toString();
    }

    public static int readFully(Reader reader, char[] dest) throws IOException {
        return Streams.readFully(reader, dest, 0, dest.length);
    }

    public static int readFully(Reader reader, char[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    public static int readFully(InputStream reader, byte[] dest) throws IOException {
        return Streams.readFully(reader, dest, 0, dest.length);
    }

    public static int readFully(InputStream reader, byte[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        for (read = 0; read < len && (r = reader.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    public static long consumeFully(InputStream inputStream) throws IOException {
        return Streams.copy(inputStream, NULL_OUTPUT_STREAM);
    }

    public static List<String> readAllLines(InputStream input) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Streams.readAllLines(input, lines::add);
        return lines;
    }

    public static void readAllLines(InputStream input, Consumer<String> consumer) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                consumer.accept(line);
            }
        }
    }

    public static InputStream noCloseStream(InputStream stream) {
        return new FilterInputStream(stream){

            @Override
            public void close() {
            }
        };
    }

    public static BytesStream flushOnCloseStream(BytesStream os) {
        return new FlushOnCloseOutputStream(os);
    }

    public static BytesReference readFully(InputStream in) throws IOException {
        try (InputStream inputStream = in;){
            BytesStreamOutput out = new BytesStreamOutput();
            Streams.copy(inputStream, (OutputStream)out);
            BytesReference bytesReference = out.bytes();
            return bytesReference;
        }
    }

    public static InputStream limitStream(InputStream in, long limit) {
        return new LimitedInputStream(in, limit);
    }

    private static class FlushOnCloseOutputStream
    extends BytesStream {
        private final BytesStream delegate;

        private FlushOnCloseOutputStream(BytesStream bytesStreamOutput) {
            this.delegate = bytesStreamOutput;
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.delegate.writeByte(b);
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.delegate.writeBytes(b, offset, length);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public BytesReference bytes() {
            return this.delegate.bytes();
        }
    }

    static class LimitedInputStream
    extends FilterInputStream {
        private static final long NO_MARK = -1L;
        private long currentLimit;
        private long limitOnLastMark;

        LimitedInputStream(InputStream in, long limit) {
            super(in);
            if (limit < 0L) {
                throw new IllegalArgumentException("limit must be non-negative");
            }
            this.currentLimit = limit;
            this.limitOnLastMark = -1L;
        }

        @Override
        public int read() throws IOException {
            int result;
            if (this.currentLimit == 0L || (result = this.in.read()) == -1) {
                return -1;
            }
            --this.currentLimit;
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result;
            if (this.currentLimit == 0L || (result = this.in.read(b, off, Math.toIntExact(Math.min((long)len, this.currentLimit)))) == -1) {
                return -1;
            }
            this.currentLimit -= (long)result;
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            long skipped = this.in.skip(Math.min(n, this.currentLimit));
            this.currentLimit -= skipped;
            return skipped;
        }

        @Override
        public int available() throws IOException {
            return Math.toIntExact(Math.min((long)this.in.available(), this.currentLimit));
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
            this.limitOnLastMark = this.currentLimit;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.in.reset();
            if (this.limitOnLastMark != -1L) {
                this.currentLimit = this.limitOnLastMark;
            }
        }
    }
}

