/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.LicenseRequestConverters;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.license.DeleteLicenseRequest;
import org.elasticsearch.client.license.GetBasicStatusResponse;
import org.elasticsearch.client.license.GetLicenseRequest;
import org.elasticsearch.client.license.GetLicenseResponse;
import org.elasticsearch.client.license.GetTrialStatusResponse;
import org.elasticsearch.client.license.PutLicenseRequest;
import org.elasticsearch.client.license.PutLicenseResponse;
import org.elasticsearch.client.license.StartBasicRequest;
import org.elasticsearch.client.license.StartBasicResponse;
import org.elasticsearch.client.license.StartTrialRequest;
import org.elasticsearch.client.license.StartTrialResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public final class LicenseClient {
    private final RestHighLevelClient restHighLevelClient;

    LicenseClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public PutLicenseResponse putLicense(PutLicenseRequest request, RequestOptions options) throws IOException {
        return (PutLicenseResponse)this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::putLicense, options, PutLicenseResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putLicenseAsync(PutLicenseRequest request, RequestOptions options, ActionListener<PutLicenseResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::putLicense, options, PutLicenseResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetLicenseResponse getLicense(GetLicenseRequest request, RequestOptions options) throws IOException {
        return (GetLicenseResponse)this.restHighLevelClient.performRequest(request, LicenseRequestConverters::getLicense, options, response -> new GetLicenseResponse(LicenseClient.convertResponseToJson(response)), Collections.emptySet());
    }

    public Cancellable getLicenseAsync(GetLicenseRequest request, RequestOptions options, ActionListener<GetLicenseResponse> listener) {
        return this.restHighLevelClient.performRequestAsync(request, LicenseRequestConverters::getLicense, options, response -> new GetLicenseResponse(LicenseClient.convertResponseToJson(response)), listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteLicense(DeleteLicenseRequest request, RequestOptions options) throws IOException {
        return (AcknowledgedResponse)this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::deleteLicense, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deleteLicenseAsync(DeleteLicenseRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::deleteLicense, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public StartTrialResponse startTrial(StartTrialRequest request, RequestOptions options) throws IOException {
        return (StartTrialResponse)this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::startTrial, options, StartTrialResponse::fromXContent, Collections.singleton(403));
    }

    public Cancellable startTrialAsync(StartTrialRequest request, RequestOptions options, ActionListener<StartTrialResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::startTrial, options, StartTrialResponse::fromXContent, listener, Collections.singleton(403));
    }

    public StartBasicResponse startBasic(StartBasicRequest request, RequestOptions options) throws IOException {
        return (StartBasicResponse)this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::startBasic, options, StartBasicResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable startBasicAsync(StartBasicRequest request, RequestOptions options, ActionListener<StartBasicResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::startBasic, options, StartBasicResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetTrialStatusResponse getTrialStatus(RequestOptions options) throws IOException {
        return (GetTrialStatusResponse)this.restHighLevelClient.performRequestAndParseEntity(Validatable.EMPTY, request -> LicenseRequestConverters.getLicenseTrialStatus(), options, GetTrialStatusResponse::fromXContent, Collections.emptySet());
    }

    public GetBasicStatusResponse getBasicStatus(RequestOptions options) throws IOException {
        return (GetBasicStatusResponse)this.restHighLevelClient.performRequestAndParseEntity(Validatable.EMPTY, request -> LicenseRequestConverters.getLicenseBasicStatus(), options, GetBasicStatusResponse::fromXContent, Collections.emptySet());
    }

    static String convertResponseToJson(Response response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new IllegalStateException("Response body expected but not returned");
        }
        if (entity.getContentType() == null) {
            throw new IllegalStateException("Elasticsearch didn't return the [Content-Type] header, unable to parse response body");
        }
        XContentType xContentType = XContentType.fromMediaTypeOrFormat((String)entity.getContentType().getValue());
        if (xContentType == null) {
            throw new IllegalStateException("Unsupported Content-Type: " + entity.getContentType().getValue());
        }
        if (xContentType == XContentType.JSON) {
            return Streams.copyToString((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
        }
        try (InputStream stream = response.getEntity().getContent();){
            String string;
            block16: {
                XContentParser parser = XContentFactory.xContent((XContentType)xContentType).createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, stream);
                try {
                    parser.nextToken();
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    builder.copyCurrentStructure(parser);
                    string = Strings.toString((XContentBuilder)builder);
                    if (parser == null) break block16;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return string;
        }
    }
}

