/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipServer;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bdware.doip.core.crypto.CertUtils;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipMessageFactory;
import org.bdware.doip.core.doipMessage.DoipResponseCode;
import org.bdware.doip.endpoint.doipServer.DoipRequestHandler;

@ChannelHandler.Sharable
public class NettyServerHandler
extends SimpleChannelInboundHandler<DoipMessage> {
    static Logger logger = Logger.getLogger(NettyServerHandler.class);
    protected DoipRequestHandler requestHandler;

    public NettyServerHandler(DoipRequestHandler doipHandler) {
        this.requestHandler = doipHandler;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DoipMessage msg) {
        if (msg.header.parameters == null || msg.header.parameters.operation == null) {
            this.replyStringWithStatus(ctx, msg, "invalid request", DoipResponseCode.Invalid);
            return;
        }
        if (msg.header.isCertified()) {
            try {
                if (!GlobalCertifications.verifyDoipMessage(msg)) {
                    logger.warn((Object)"verification failed");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (msg.credential != null) {
            logger.debug((Object)("[Caller] client ID: " + msg.credential.getSigner()));
        } else {
            logger.debug((Object)("[Caller] client ID: " + GlobalCertifications.getUserIDByContext(ctx)));
        }
        DoipMessage response = this.requestHandler.onRequest(msg);
        if (response != null) {
            this.sendResponse(ctx, response);
        } else {
            this.defaultHandler(ctx, msg);
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        if (ctx.pipeline().get(SslHandler.class) != null) {
            ctx.pipeline().get(SslHandler.class).handshakeFuture().addListener(future -> {
                if (future.isSuccess()) {
                    logger.info((Object)"TLS connection established");
                    SSLSession ss = ctx.pipeline().get(SslHandler.class).engine().getSession();
                    if (GlobalCertifications.needAuthentication) {
                        X509Certificate cert = ss.getPeerCertificateChain()[0];
                        String info = CertUtils.encodeKey(cert.getPublicKey());
                        logger.debug((Object)("PublicKey:" + info));
                        info = cert.getSubjectDN().getName();
                        logger.debug((Object)("Certification Owner:" + info));
                        info = cert.getIssuerDN().getName();
                        logger.debug((Object)("Certification Issuer:" + info));
                        info = cert.getSigAlgName();
                        logger.debug((Object)("Sign Algorithm:" + info));
                    }
                } else {
                    logger.info((Object)"TLS connection established failed");
                }
            });
        }
    }

    public void defaultHandler(ChannelHandlerContext ctx, DoipMessage request) {
        this.replyStringWithStatus(ctx, request, "Unsupported Operation!", DoipResponseCode.Declined);
    }

    protected void replyStringWithStatus(ChannelHandlerContext ctx, DoipMessage request, String str, DoipResponseCode resp) {
        DoipMessage response = new DoipMessageFactory.DoipMessageBuilder().createResponse(resp, request).setBody(str.getBytes()).create();
        this.sendResponse(ctx, response);
    }

    public void sendResponse(ChannelHandlerContext ctx, DoipMessage response) {
        if (response.header.isCertified()) {
            try {
                GlobalCertifications.signDoipMessage(response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ctx.writeAndFlush(response);
    }
}

