/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipClient;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.endpoint.doipClient.DoipClientChannel;
import org.bdware.doip.endpoint.doipClient.DoipMessageCallback;
import org.bdware.doip.endpoint.doipClient.NettyDoipClientHandler;
import org.bdware.doip.endpoint.doipClient.NettyDoipTCPClientChannel;
import org.bdware.doip.endpoint.doipClient.NettyDoipTlsClientChannel;
import org.bdware.doip.endpoint.doipClient.NettyDoipUDPClientChannel;

public abstract class NettyDoipClientChannel
implements DoipClientChannel {
    static Logger logger = Logger.getLogger(NettyDoipClientChannel.class);
    NettyDoipClientHandler handler;
    InetSocketAddress remoteAddress;
    boolean encryptedChannel = false;
    boolean isConnected = false;
    Channel channel;

    public static DoipClientChannel createByRepoUrl(String url) {
        try {
            URI uri = new URI(url);
            logger.debug((Object)("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort()));
            switch (uri.getScheme()) {
                case "udp": 
                case "UDP": {
                    return new NettyDoipUDPClientChannel();
                }
                case "tcp": 
                case "TCP": {
                    return new NettyDoipTCPClientChannel();
                }
                case "tls": 
                case "TLS": {
                    return new NettyDoipTlsClientChannel();
                }
            }
            logger.error((Object)"unsupported transfer scheme");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void sendMessage(DoipMessage message, DoipMessageCallback cb) {
        if (this.handler == null) {
            logger.error((Object)"client handler not set yet");
            return;
        }
        if (!this.isConnected) {
            logger.error((Object)"client not connected, connect first!");
        }
        if (GlobalCertifications.secureMode) {
            message.header.setIsEncrypted(true);
            message.header.setClientPublicKey(GlobalCertifications.getGlobalKeypair().getPublic());
        }
        if (GlobalCertifications.needAuthentication || GlobalCertifications.secureMode) {
            try {
                GlobalCertifications.signDoipMessage(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (message.getSender() == null) {
            message.setSender(this.remoteAddress);
        }
        this.handler.sendMessage(message, cb);
    }

    @Override
    public abstract void connect(String var1) throws URISyntaxException;

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }
}

