/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.codec.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.doip.core.codec.packet.AbstractEnvelopeReceiveBuffer;
import org.bdware.doip.core.codec.packet.AbstractEnvelopeSendBuffer;
import org.bdware.doip.core.codec.packet.GreedyUDPEnvelopeReceiveBuffer;
import org.bdware.doip.core.codec.packet.PacketMessageCodec;
import org.bdware.doip.core.codec.packet.PacketMessageCodecImpl;
import org.bdware.doip.core.codec.packet.PassiveEnvelopeSenderBuffer;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.MessageEnvelope;

public class PacketNettyUDPCodec
extends MessageToMessageCodec<DatagramPacket, DoipMessage> {
    Logger logger = Logger.getLogger(PacketNettyUDPCodec.class);
    PacketMessageCodec codec = new PacketMessageCodecImpl();
    HashMap<Integer, AbstractEnvelopeReceiveBuffer> receiveBufferMap = new HashMap();
    HashMap<Integer, AbstractEnvelopeSendBuffer> sendBufferMap = new HashMap();

    @Override
    protected void encode(ChannelHandlerContext ctx, DoipMessage msg, List<Object> out) {
        this.logger.debug((Object)"encoding DOIP message to UDP Packets");
        try {
            if (msg.getMTU() > 1024) {
                msg.setMTU(1024);
            }
            if (this.sendBufferMap.get(msg.requestID) != null) {
                this.logger.error((Object)"duplicate requestID");
                return;
            }
            PassiveEnvelopeSenderBuffer senderBuffer = new PassiveEnvelopeSenderBuffer(msg.requestID, ctx);
            ArrayList<MessageEnvelope> envelpoes = this.codec.MessageToEnvelopes(msg);
            for (MessageEnvelope env : envelpoes) {
                ByteBuf buff = Unpooled.directBuffer();
                senderBuffer.pushToBuffer(env);
                buff.writeBytes(this.codec.EnvelopeToBytes(env));
                this.sendBufferMap.put(msg.requestID, senderBuffer);
                out.add(new DatagramPacket(buff, msg.getSender()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) {
        try {
            ByteBuf bf = (ByteBuf)msg.content();
            byte[] envBytes = new byte[bf.readableBytes()];
            bf.readBytes(envBytes);
            MessageEnvelope envelope = this.codec.BytesToEnvelope(envBytes);
            envelope.setSender((InetSocketAddress)msg.sender());
            if (envelope.isResend()) {
                if (this.sendBufferMap.get(envelope.requestId) != null && this.sendBufferMap.get(envelope.requestId).receiveAck(envelope)) {
                    this.sendBufferMap.remove(envelope.requestId);
                }
            } else {
                AbstractEnvelopeReceiveBuffer recvBuffer = this.receiveBufferMap.get(envelope.requestId);
                if (recvBuffer == null) {
                    recvBuffer = new GreedyUDPEnvelopeReceiveBuffer(envelope.requestId, ctx);
                    this.receiveBufferMap.put(envelope.requestId, recvBuffer);
                }
                recvBuffer.addEnvelope(envelope);
                if (recvBuffer.isCompleted()) {
                    ArrayList<MessageEnvelope> envList = recvBuffer.getSortedEnvelopes();
                    out.add(this.codec.EnvelopesToMessage(envList));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

