/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.application;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DoipServiceConfig {
    static Logger logger = Logger.getLogger(DoipServiceConfig.class);
    public String LHSProxyAddress;
    public String ownerHandle;
    public String certPath;
    public String certPassword;
    public String repoID;
    public String listeners;
    public String serviceDescription;
    public String serviceName;
    public String type;

    public static DoipServiceConfig loadFromConfigFile(String filePath) {
        logger.info((Object)("load config from: " + filePath));
        try {
            String configJson = DoipServiceConfig.readFile(filePath);
            return (DoipServiceConfig)new Gson().fromJson(configJson, DoipServiceConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String readFile(String path) throws Exception {
        File file = new File(path);
        logger.debug((Object)("conf file absolute path: " + file.getAbsolutePath()));
        StringBuilder configJson = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        while (line != null) {
            configJson.append(line);
            line = br.readLine();
        }
        br.close();
        return configJson.toString();
    }

    public void save(String filePath) throws IOException {
        File f = new File(filePath);
        logger.info((Object)("config file path: " + f.getAbsolutePath()));
        FileWriter fw = new FileWriter(f);
        fw.write(new Gson().toJson((Object)this));
        fw.flush();
    }
}

