/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.implementation;

import org.apache.log4j.Logger;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipResponseCode;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.Element;
import org.bdware.doip.core.model.handleRecord.DoHandleRecord;
import org.bdware.doip.core.utils.Helper;
import org.bdware.doip.endpoint.doipServer.DoipServiceInfo;
import org.bdware.doip.endpoint.doipServer.RepositoryHandlerBase;
import org.bdware.doip.endpoint.irpClient.GlobalIrpClient;
import org.bdware.doip.endpoint.irpClient.IrpClient;
import org.bdware.doip.implementation.DoStorage;

public class SimpleRepositoryHandler
extends RepositoryHandlerBase {
    Logger logger = Logger.getLogger(SimpleRepositoryHandler.class);
    DoStorage store;

    public SimpleRepositoryHandler(DoipServiceInfo info, DoStorage s) {
        super(info);
        this.serviceInfo = info;
        this.store = s;
    }

    @Override
    public DoipMessage handleHello(DoipMessage request) {
        return this.replyDoipServiceInfo(request);
    }

    @Override
    public DoipMessage handleListOps(DoipMessage request) {
        return this.replyAllOperations(request);
    }

    @Override
    public DoipMessage handleCreate(DoipMessage request) {
        if (!Helper.checkPermission(request, this.store)) {
            return this.replyStringWithStatus(request, "user authentication fail", DoipResponseCode.UnAuth_Client);
        }
        try {
            DigitalObject ret;
            DigitalObject digitalObject = request.body.getDataAsDigitalObject();
            if (!request.header.parameters.id.equals(this.serviceInfo.id)) {
                return this.replyStringWithStatus(request, "Wrong operation targetID, should be: " + this.serviceInfo.id, DoipResponseCode.Invalid);
            }
            if (digitalObject.id == null || digitalObject.id.equals("")) {
                this.logger.debug((Object)"register DO for user");
                IrpClient irpClient = GlobalIrpClient.getGlobalClient();
                DoHandleRecord doHR = new DoHandleRecord(this.serviceInfo.owner, this.serviceInfo.id);
                digitalObject.id = irpClient.register(doHR);
            }
            if ((ret = this.store.getDoByID(digitalObject.id)) != null) {
                return this.replyStringWithStatus(request, "Failed: the data of this DO is already existed.", DoipResponseCode.DoAlreadyExist);
            }
            this.logger.debug((Object)("Message body length: " + request.body.getLength()));
            this.logger.info((Object)("create DO identifier : " + digitalObject.id));
            this.store.storeDo(digitalObject);
            if (digitalObject.elements != null) {
                for (Element e : digitalObject.elements) {
                    e.excludeData();
                }
            }
            return this.replyDO(request, digitalObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }

    @Override
    public DoipMessage handleUpdate(DoipMessage request) {
        if (!Helper.checkPermission(request, this.store)) {
            return this.replyStringWithStatus(request, "user authentication fail", DoipResponseCode.UnAuth_Client);
        }
        try {
            DigitalObject digitalObject = request.body.getDataAsDigitalObject();
            if (!request.header.parameters.id.equals(digitalObject.id)) {
                return this.replyStringWithStatus(request, "Invalid request: different identifiers in DO and message header.", DoipResponseCode.Invalid);
            }
            DigitalObject ret = this.store.getDoByID(digitalObject.id);
            if (ret == null) {
                return this.replyStringWithStatus(request, "Failed: DO is not existed.", DoipResponseCode.DoNotFound);
            }
            this.store.updateDo(digitalObject);
            if (digitalObject.elements != null) {
                for (Element e : digitalObject.elements) {
                    e.excludeData();
                }
            }
            return this.replyDO(request, digitalObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }

    @Override
    public DoipMessage handleDelete(DoipMessage request) {
        if (!Helper.checkPermission(request, this.store)) {
            return this.replyStringWithStatus(request, "user authentication fail", DoipResponseCode.UnAuth_Client);
        }
        try {
            DigitalObject ret = this.store.getDoByID(request.header.parameters.id);
            if (ret == null) {
                return this.replyStringWithStatus(request, "Failed: DO is not existed.", DoipResponseCode.DoNotFound);
            }
            this.store.deleteDoByID(request.header.parameters.id);
            return this.replyNull(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }

    @Override
    public DoipMessage handleRetrieve(DoipMessage request) {
        try {
            DigitalObject ret = this.store.getDoByID(request.header.parameters.id);
            if (ret == null) {
                return this.replyStringWithStatus(request, "Failed: DO is not existed.", DoipResponseCode.DoNotFound);
            }
            if (request.header.parameters.attributes != null && request.header.parameters.attributes.has("element")) {
                for (Element e : ret.elements) {
                    if (!e.id.equals(request.header.parameters.attributes.get("element").getAsString())) continue;
                    return this.replyString(request, e.getData() == null ? "" : new String(e.getData()));
                }
                return this.replyStringWithStatus(request, "element not found: " + request.header.parameters.attributes.get("element"), DoipResponseCode.DoNotFound);
            }
            if (request.header.parameters.attributes == null || !request.header.parameters.attributes.has("includeElementData")) {
                this.logger.debug((Object)"clean element data");
                for (Element e : ret.elements) {
                    e.excludeData();
                }
            }
            return this.replyDO(request, ret);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }
}

