/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipClient;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipMessageFactory;
import org.bdware.doip.endpoint.doipClient.DoipMessageCallback;

public class SyncResult {
    Map<Integer, DoipMessageCallback> waitObj = new HashMap<Integer, DoipMessageCallback>();
    public static final HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 5L, TimeUnit.MILLISECONDS, 2);

    public void wakeUp(int requestID, DoipMessage result) {
        DoipMessageCallback ob = this.waitObj.get(requestID);
        this.waitObj.remove(requestID);
        if (ob != null) {
            ob.onResult(result);
        }
    }

    public void sleep(int requestID, DoipMessageCallback cb) {
        if (!this.waitObj.containsKey(requestID)) {
            this.waitObj.put(requestID, cb);
        }
        TimerTask tt = timeout -> {
            DoipMessage response = DoipMessageFactory.createTimeoutResponse(requestID);
            this.wakeUp(requestID, response);
        };
        timer.newTimeout(tt, 20L, TimeUnit.SECONDS);
    }

    public void sleepWithTimeout(final int requestID, DoipMessageCallback cb, int timeOut) {
        if (!this.waitObj.containsKey(requestID)) {
            this.waitObj.put(requestID, cb);
        }
        TimerTask tt = new TimerTask(){

            @Override
            public void run(Timeout timeout) {
                DoipMessage response = DoipMessageFactory.createTimeoutResponse(requestID);
                SyncResult.this.wakeUp(requestID, response);
            }
        };
        timer.newTimeout(tt, timeOut, TimeUnit.SECONDS);
    }
}

