/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.implementation;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.apache.log4j.Logger;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipResponseCode;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.DoType;
import org.bdware.doip.core.model.digitalObject.Element;
import org.bdware.doip.core.model.handleRecord.DoHandleRecord;
import org.bdware.doip.core.utils.Helper;
import org.bdware.doip.endpoint.doipServer.DoipServiceInfo;
import org.bdware.doip.endpoint.doipServer.RepositoryHandlerBase;
import org.bdware.doip.endpoint.irpClient.GlobalIrpClient;
import org.bdware.doip.endpoint.irpClient.IrpClient;
import org.bdware.doip.implementation.DoStorage;

public class SimpleRepositoryHandler
extends RepositoryHandlerBase {
    Logger logger = Logger.getLogger(SimpleRepositoryHandler.class);
    DoStorage store;
    String counterId = "doipService/do.all";
    DigitalObject ret;

    public SimpleRepositoryHandler(DoipServiceInfo info, DoStorage s) {
        super(info);
        this.serviceInfo = info;
        this.store = s;
    }

    @Override
    public DoipMessage handleHello(DoipMessage request) {
        return this.replyDoipServiceInfo(request);
    }

    @Override
    public DoipMessage handleListOps(DoipMessage request) {
        return this.replyAllOperations(request);
    }

    @Override
    public DoipMessage handleCreate(DoipMessage request) {
        this.logger.info("handle create: begin");
        if (!Helper.checkPermission(request, this.store)) {
            this.logger.warn("user user authentication fail");
            return this.replyStringWithStatus(request, "user authentication fail", DoipResponseCode.UnAuth_Client);
        }
        try {
            DigitalObject digitalObject = request.body.getDataAsDigitalObject();
            if (!request.header.parameters.id.equals(this.serviceInfo.id)) {
                this.logger.warn("Wrong operation targetID, should be: " + this.serviceInfo.id);
                return this.replyStringWithStatus(request, "Wrong operation targetID, should be: " + this.serviceInfo.id, DoipResponseCode.Invalid);
            }
            if (digitalObject.id == null || digitalObject.id.equals("")) {
                this.logger.info("id is empty, register DO for user");
                IrpClient irpClient = GlobalIrpClient.getGlobalClient();
                DoHandleRecord doHR = new DoHandleRecord(this.serviceInfo.owner, this.serviceInfo.id);
                digitalObject.id = irpClient.register(doHR);
                this.logger.info("DO identifier : " + digitalObject.id);
            }
            this.logger.info("check if do already exist");
            this.ret = this.store.getDoByID(digitalObject.id);
            if (this.ret != null) {
                this.logger.error("the data of this DO is already existed.");
                return this.replyStringWithStatus(request, "Failed: the data of this DO is already existed.", DoipResponseCode.DoAlreadyExist);
            }
            this.logger.debug("Message body length: " + request.body.getLength());
            this.logger.info("store do");
            this.store.storeDo(digitalObject);
            if (digitalObject.elements != null) {
                for (Element e : digitalObject.elements) {
                    e.excludeData();
                }
            }
            this.logger.info("add do to counter: begin");
            DigitalObject ret = this.store.getDoByID(this.counterId);
            if (ret != null) {
                JsonObject targetID = new JsonObject();
                targetID.addProperty("id", digitalObject.id);
                ret.attributes.get("counter").getAsJsonArray().add(targetID);
                this.store.updateDo(ret);
                this.logger.info("add " + digitalObject.id + " to counter");
            } else {
                ret = new DigitalObject(this.counterId, DoType.DO);
                JsonArray jsonArray = new JsonArray();
                JsonObject targetID = new JsonObject();
                targetID.addProperty("id", digitalObject.id);
                jsonArray.add(targetID);
                ret.addAttribute("counter", jsonArray);
                this.store.storeDo(ret);
                this.logger.info("add " + digitalObject.id + " to counter");
            }
            this.logger.info("add do to counter: end");
            return this.replyDO(request, digitalObject);
        }
        catch (Exception e) {
            this.logger.error("server exception");
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }

    @Override
    public DoipMessage handleUpdate(DoipMessage request) {
        if (!Helper.checkPermission(request, this.store)) {
            return this.replyStringWithStatus(request, "user authentication fail", DoipResponseCode.UnAuth_Client);
        }
        try {
            DigitalObject digitalObject = request.body.getDataAsDigitalObject();
            if (!request.header.parameters.id.equals(digitalObject.id)) {
                return this.replyStringWithStatus(request, "Invalid request: different identifiers in DO and message header.", DoipResponseCode.Invalid);
            }
            DigitalObject ret = this.store.getDoByID(digitalObject.id);
            if (ret == null) {
                return this.replyStringWithStatus(request, "Failed: DO is not existed.", DoipResponseCode.DoNotFound);
            }
            this.store.updateDo(digitalObject);
            if (digitalObject.elements != null) {
                for (Element e : digitalObject.elements) {
                    e.excludeData();
                }
            }
            return this.replyDO(request, digitalObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }

    @Override
    public DoipMessage handleDelete(DoipMessage request) {
        this.logger.info("handle delete: begin");
        if (!Helper.checkPermission(request, this.store)) {
            this.logger.warn("user authentication fail");
            return this.replyStringWithStatus(request, "user authentication fail", DoipResponseCode.UnAuth_Client);
        }
        try {
            this.logger.info("check if do exits");
            DigitalObject targetDO = this.store.getDoByID(request.header.parameters.id);
            if (targetDO == null) {
                this.logger.warn("DO is not existed");
                return this.replyStringWithStatus(request, "Failed: DO is not existed.", DoipResponseCode.DoNotFound);
            }
            this.logger.info("delete do");
            this.store.deleteDoByID(request.header.parameters.id);
            this.logger.info("delete do from counter: begin");
            DigitalObject counterDO = this.store.getDoByID(this.counterId);
            assert (counterDO != null);
            JsonArray jsonArray = counterDO.attributes.get("counter").getAsJsonArray();
            JsonObject targetID = new JsonObject();
            targetID.addProperty("id", request.header.parameters.id);
            jsonArray.remove(targetID);
            this.logger.info("delete " + request.header.parameters.id + " from counter");
            this.store.updateDo(counterDO);
            this.logger.info("delete do from counter: end");
            return this.replyNull(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }

    @Override
    public DoipMessage handleRetrieve(DoipMessage request) {
        try {
            DigitalObject ret = this.store.getDoByID(request.header.parameters.id);
            if (ret == null) {
                return this.replyStringWithStatus(request, "Failed: DO is not existed.", DoipResponseCode.DoNotFound);
            }
            if (ret.elements != null) {
                if (request.header.parameters.attributes != null && request.header.parameters.attributes.has("element")) {
                    for (Element e : ret.elements) {
                        if (!e.id.equals(request.header.parameters.attributes.get("element").getAsString())) continue;
                        return this.replyString(request, e.getData() == null ? "" : new String(e.getData()));
                    }
                    return this.replyStringWithStatus(request, "element not found: " + request.header.parameters.attributes.get("element"), DoipResponseCode.DoNotFound);
                }
                if (request.header.parameters.attributes == null || !request.header.parameters.attributes.has("includeElementData")) {
                    this.logger.debug("clean element data");
                    for (Element e : ret.elements) {
                        e.excludeData();
                    }
                }
            }
            return this.replyDO(request, ret);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }
}

