/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipServer;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.ssl.SslHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bdware.doip.core.crypto.CertUtils;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipMessageFactory;
import org.bdware.doip.core.doipMessage.DoipResponseCode;
import org.bdware.doip.endpoint.doipServer.DoipRequestHandler;

@ChannelHandler.Sharable
public class NettyServerHandler
extends SimpleChannelInboundHandler<DoipMessage> {
    static Logger logger = Logger.getLogger(NettyServerHandler.class);
    protected DoipRequestHandler requestHandler;
    HashMap<Integer, PushFileStream> clientMap = new HashMap();

    public NettyServerHandler(DoipRequestHandler doipHandler) {
        this.requestHandler = doipHandler;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DoipMessage msg) {
        if (msg.header.parameters == null || msg.header.parameters.operation == null) {
            this.replyStringWithStatus(ctx, msg, "invalid request", DoipResponseCode.Invalid);
            return;
        }
        if (msg.header.isCertified()) {
            try {
                if (!GlobalCertifications.verifyDoipMessage(msg)) {
                    logger.warn("verification failed");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (msg.credential != null) {
            logger.debug("[Caller] client ID: " + msg.credential.getSigner());
        } else {
            logger.debug("[Caller] client ID: " + GlobalCertifications.getUserIDByContext(ctx));
        }
        DoipMessage response = this.requestHandler.onRequest(msg);
        if (response != null) {
            if (response.header.parameters.attributes != null && response.header.parameters.attributes.get("action") != null) {
                if (response.header.parameters.attributes.get("action").getAsString().equals("start")) {
                    logger.info("send DO stream");
                    this.sendResponseUsingStream(ctx, response);
                } else {
                    logger.info("stop stream");
                    this.stopStream(ctx, response);
                }
            } else {
                this.sendResponse(ctx, response);
            }
        } else {
            this.defaultHandler(ctx, msg);
        }
    }

    private void sendResponseUsingStream(ChannelHandlerContext ctx, DoipMessage response) {
        ByteArrayInputStream di = new ByteArrayInputStream(response.body.encodedData);
        PushFileStream pfs = new PushFileStream(ctx, response, di);
        pfs.start();
        this.clientMap.put(response.requestID, pfs);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        if (ctx.pipeline().get(SslHandler.class) != null) {
            ctx.pipeline().get(SslHandler.class).handshakeFuture().addListener(future -> {
                if (future.isSuccess()) {
                    logger.info("TLS connection established");
                    SSLSession ss = ctx.pipeline().get(SslHandler.class).engine().getSession();
                    if (GlobalCertifications.needAuthentication) {
                        X509Certificate cert = ss.getPeerCertificateChain()[0];
                        String info = CertUtils.encodeKey(cert.getPublicKey());
                        logger.debug("PublicKey:" + info);
                        info = cert.getSubjectDN().getName();
                        logger.debug("Certification Owner:" + info);
                        info = cert.getIssuerDN().getName();
                        logger.debug("Certification Issuer:" + info);
                        info = cert.getSigAlgName();
                        logger.debug("Sign Algorithm:" + info);
                    }
                } else {
                    logger.info("TLS connection established failed");
                }
            });
        }
    }

    public void defaultHandler(ChannelHandlerContext ctx, DoipMessage request) {
        this.replyStringWithStatus(ctx, request, "Unsupported Operation!", DoipResponseCode.Declined);
    }

    protected void replyStringWithStatus(ChannelHandlerContext ctx, DoipMessage request, String str, DoipResponseCode resp) {
        DoipMessage response = new DoipMessageFactory.DoipMessageBuilder().createResponse(resp, request).setBody(str.getBytes()).create();
        this.sendResponse(ctx, response);
    }

    public void sendResponse(ChannelHandlerContext ctx, DoipMessage response) {
        logger.debug("body length: " + response.body.getLength());
        if (response.header.isCertified()) {
            try {
                GlobalCertifications.signDoipMessage(response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ctx.writeAndFlush(response);
    }

    private void stopStream(ChannelHandlerContext ctx, DoipMessage msg) {
        logger.info("stop stream: ");
        this.clientMap.get(msg.requestID).interrupt();
        this.clientMap.remove(msg.requestID);
        this.replyStringWithStatus(ctx, msg, "", DoipResponseCode.Success);
    }

    private class PushFileStream
    extends Thread {
        ChannelHandlerContext ctx;
        DoipMessage inMsg;
        InputStream streaming;

        PushFileStream(ChannelHandlerContext ctx, DoipMessage msg, InputStream f) {
            this.ctx = ctx;
            this.inMsg = msg;
            this.streaming = f;
        }

        @Override
        public void run() {
            int total = 0;
            int count = 0;
            logger.debug("Start to push stream!");
            try {
                BufferedInputStream buffer = new BufferedInputStream(this.streaming);
                while (!Thread.currentThread().isInterrupted()) {
                    byte[] payload;
                    byte[] fileBytes = new byte[800];
                    int len = buffer.read(fileBytes, 0, 800);
                    total += len;
                    ++count;
                    if (len < 800) {
                        logger.debug("====Last frame, length: " + len + ",  total: " + total);
                        payload = new byte[len];
                        for (int i = 0; i < len; ++i) {
                            payload[i] = fileBytes[i];
                        }
                    } else {
                        payload = fileBytes;
                    }
                    logger.debug("Send elements bytes, length: " + payload.length);
                    NettyServerHandler.this.replyStringWithStatus(this.ctx, this.inMsg, new String(payload), DoipResponseCode.Success);
                    if (buffer.available() <= 0) break;
                    if (count % 10 != 0) continue;
                    PushFileStream.sleep(500L);
                }
                NettyServerHandler.this.stopStream(this.ctx, this.inMsg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

