/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.application.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.Security;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.crypto.signature.JWK;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.DoType;
import org.bdware.doip.core.model.handleRecord.HandleRecordBase;
import org.bdware.doip.core.model.metadata.SearchParameter;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.doipClient.DoipClientImpl;
import org.bdware.doip.endpoint.doipClient.DoipMessageCallback;
import org.bdware.doip.endpoint.irpClient.GlobalIrpClient;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DOIPCMDClient {
    static Logger logger = Logger.getLogger(DOIPCMDClient.class);

    public static void main(String[] args) {
        DoType doTypeFormal;
        String doCont;
        String doType;
        String doId;
        String doiId;
        ClientConfig clientConfig;
        ResponseContainer container = new ResponseContainer();
        SyncCallback cb = new SyncCallback(container);
        long TimeOut = 3000L;
        Options opts = DOIPCMDClient.getOptions();
        DefaultParser parser = new DefaultParser();
        CommandLine cl = null;
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(120);
        String header = "basic doip operations to illustrate usage of the protocol\n\n";
        String footer = "\nPlease report issues at https://gitee.com/BDWare/doip-sdk.git";
        DOIPCMDClient.init();
        DoipClientImpl doipClient = new DoipClientImpl();
        try {
            cl = parser.parse(opts, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cl.getOptions().length == 0 || cl.hasOption('h')) {
            hf.printHelp("DOIPCMDClient", header, opts, footer, true);
            System.exit(1);
        }
        String confPath = "default_client.json";
        if (cl.hasOption("cf")) {
            confPath = cl.getOptionValue("cf");
        }
        if ((clientConfig = DOIPCMDClient.loadFromConfigFile(confPath)) == null) {
            logger.fatal("fail to load config file: " + confPath);
            System.exit(1);
        }
        GlobalConfigurations.User_Handle = clientConfig.userID;
        GlobalConfigurations.cordraUsername = clientConfig.userName;
        GlobalConfigurations.cordraPassword = clientConfig.userPass;
        GlobalConfigurations.DoipServiceID = clientConfig.repoID;
        GlobalConfigurations.enableIRP = clientConfig.enableIRP;
        if (clientConfig.enableIRP) {
            HandleRecordBase serviceHR = null;
            try {
                serviceHR = GlobalIrpClient.getGlobalClient().resolve(clientConfig.repoID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            logger.debug("service HR:" + new Gson().toJson(serviceHR));
            String serviceInfo = serviceHR.handleValues.get(DoType.DOIPServiceInfo.getName()).getAsString();
            logger.debug("service Info:" + serviceInfo);
            JsonObject serviceJson = new Gson().fromJson(serviceInfo, JsonObject.class);
            String pkString = serviceJson.get("publicKey").getAsString();
            logger.debug("public key" + pkString);
            try {
                GlobalConfigurations.servicePkFromIRP = JWK.load(serviceJson.get("publicKey").getAsString()).getPublicKey();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.warn("fail to get service public key from irp");
            }
        }
        doipClient.connect(clientConfig.repoURL);
        if (cl.hasOption('i')) {
            doipClient.hello(clientConfig.repoID, cb);
            DoipMessage doipMessage = DOIPCMDClient.getResp(cb, container, TimeOut);
        } else if (cl.hasOption('l')) {
            doipClient.listOperations(clientConfig.repoID, cb);
            DOIPCMDClient.getResp(cb, container, TimeOut);
        } else if (cl.hasOption('r')) {
            doiId = cl.getOptionValue("r");
            if (doiId != null && !doiId.isEmpty()) {
                doipClient.retrieve(doiId, null, true, cb);
                DOIPCMDClient.getResp(cb, container, TimeOut);
            }
        } else if (cl.hasOption('c')) {
            doId = cl.getOptionValues("c")[0];
            doType = cl.getOptionValues("c")[1];
            doCont = cl.getOptionValues("c")[2];
            doTypeFormal = doType.equals("DO") ? DoType.DO : (doType.equals("Meta") ? DoType.Metadata : DoType.UnKnown);
            DigitalObject digitalObject = new DigitalObject(doId, doTypeFormal);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("create", doCont);
            jsonObject.addProperty("name", "create");
            jsonObject.addProperty("description", "this is an example for create");
            digitalObject.addAttribute("content", jsonObject);
            doipClient.create(clientConfig.repoID, digitalObject, cb);
            DOIPCMDClient.getResp(cb, container, TimeOut);
        } else if (cl.hasOption('u')) {
            doId = cl.getOptionValues("u")[0];
            doType = cl.getOptionValues("u")[1];
            doCont = cl.getOptionValues("u")[2];
            doTypeFormal = doType.equals("DO") ? DoType.DO : (doType.equals("Meta") ? DoType.Metadata : DoType.UnKnown);
            DigitalObject digitalObject = new DigitalObject(doId, doTypeFormal);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("update", doCont);
            jsonObject.addProperty("name", "update");
            jsonObject.addProperty("description", "this is an example for update");
            digitalObject.addAttribute("content", jsonObject);
            doipClient.update(digitalObject, cb);
            DOIPCMDClient.getResp(cb, container, TimeOut);
        } else if (cl.hasOption('d')) {
            doiId = cl.getOptionValue("d");
            if (doiId != null && !doiId.isEmpty()) {
                doipClient.delete(doiId, cb);
                DOIPCMDClient.getResp(cb, container, TimeOut);
            }
        } else if (cl.hasOption('s')) {
            String keyword = cl.getOptionValue("s");
            SearchParameter searchParameter = new SearchParameter(keyword, 0, 10, "id:ASC", "full");
            doipClient.search(clientConfig.repoID, searchParameter, cb);
            DOIPCMDClient.getResp(cb, container, TimeOut);
        }
        if (doipClient.isConnected()) {
            logger.debug("close channel");
            doipClient.close();
            System.exit(0);
        }
    }

    public static Options getOptions() {
        Options opts = new Options();
        opts.addOption("h", false, "display this help message");
        opts.addOption(Option.builder("i").longOpt("hello").hasArg(false).desc("get doip service information, e.g. -i").build());
        opts.addOption(Option.builder("c").longOpt("create").hasArg(true).desc("create do in doip repository/registry, e.g. create do: -c 86.5000.470/do.test DO message, create meta: -c 86.5000.470/do.test Meta description").numberOfArgs(3).build());
        opts.addOption(Option.builder("l").longOpt("list").hasArg(false).desc("get repository/registry supported operations, e.g. -l").build());
        opts.addOption(Option.builder("r").longOpt("retrieve").hasArg(true).desc("retrieve do in doip repository/registry, e.g. -r 86.5000.470/do.test").numberOfArgs(1).build());
        opts.addOption(Option.builder("s").longOpt("search").hasArg(true).desc("search meta info in registry, e.g. -s key_word").numberOfArgs(1).build());
        opts.addOption(Option.builder("u").longOpt("update").hasArg(true).desc("update do in doip repository/registry, e.g. -u 86.5000.470/do.test DO new_message").numberOfArgs(3).build());
        opts.addOption(Option.builder("d").longOpt("delete").hasArg(true).desc("delete do in doip repository/registry, e.g. -d 86.5000.470/do.test").numberOfArgs(1).build());
        opts.addOption(Option.builder("cf").longOpt("config").hasArg(true).desc("path to config file").numberOfArgs(1).build());
        return opts;
    }

    public static void init() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        GlobalIrpClient.useInternalIrpClient(GlobalCertifications.localKeypair, GlobalConfigurations.User_Handle, GlobalConfigurations.LHS_Address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DoipMessage getResp(SyncCallback cb, ResponseContainer container, long TimeOut) {
        SyncCallback syncCallback = cb;
        synchronized (syncCallback) {
            try {
                cb.wait(TimeOut);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return container.response;
    }

    public static ClientConfig loadFromConfigFile(String filePath) {
        logger.info("load config from: " + filePath);
        try {
            String configJson = DOIPCMDClient.readFile(filePath);
            return new Gson().fromJson(configJson, ClientConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String readFile(String path) throws Exception {
        File file = new File(path);
        logger.debug("conf file absolute path: " + file.getAbsolutePath());
        StringBuilder configJson = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        while (line != null) {
            configJson.append(line);
            line = br.readLine();
        }
        br.close();
        return configJson.toString();
    }

    class ClientConfig {
        public String repoID;
        public String repoURL;
        public String userID;
        public String userName;
        public String userPass;
        public boolean enableIRP;

        ClientConfig() {
        }
    }

    static class ResponseContainer {
        DoipMessage response;

        ResponseContainer() {
        }
    }

    static class SyncCallback
    implements DoipMessageCallback {
        ResponseContainer responseContainer;

        public SyncCallback(ResponseContainer container) {
            this.responseContainer = container;
        }

        @Override
        public synchronized void onResult(DoipMessage msg) {
            this.responseContainer.response = msg;
            this.notifyAll();
        }
    }
}

