/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.application;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.security.Security;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.doip.application.DoipServiceConfig;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.model.handleRecord.DoipServiceHandleRecord;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.doipServer.DoipListenerInfo;
import org.bdware.doip.endpoint.doipServer.DoipServer;
import org.bdware.doip.endpoint.doipServer.DoipServerImpl;
import org.bdware.doip.endpoint.doipServer.DoipServiceInfo;
import org.bdware.doip.endpoint.irpClient.GlobalIrpClient;
import org.bdware.doip.implementation.StreamRepositoryHandler;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Mp3Repository {
    static Logger logger = Logger.getLogger(Mp3Repository.class);
    static String configFilePath = "config.json";
    static boolean useStaticConfig = true;
    public static String listeners = "[{\"url\":\"udp://127.0.0.1:1717\",\"protocolVersion\":\"2.1\",\"messageFormat\":\"packet\"}]";
    public static String repoID = "86.5000.470/doip.localStreamRepo_bdw";
    public static String serviceDescription = "test local stream Repository";
    public static String serviceName = "Test Stream";
    public static String type;

    public static void main(String[] args) {
        if (args.length > 0) {
            configFilePath = args[0] + "_" + configFilePath;
        }
        DoipServiceConfig localConfig = DoipServiceConfig.loadFromConfigFile(configFilePath);
        if (!useStaticConfig && localConfig != null && localConfig.listeners != null && !localConfig.listeners.equals("")) {
            if (localConfig.LHSProxyAddress != null) {
                GlobalConfigurations.LHS_Address = localConfig.LHSProxyAddress;
            }
            if (localConfig.ownerHandle != null) {
                GlobalConfigurations.User_Handle = localConfig.ownerHandle;
            }
            if (localConfig.certPath != null) {
                GlobalConfigurations.certPath = localConfig.certPath;
            }
            if (localConfig.certPassword != null) {
                GlobalConfigurations.certPassword = localConfig.certPassword;
            }
        } else {
            logger.info("cannot find config file, using static config");
            localConfig = new DoipServiceConfig();
            localConfig.serviceDescription = serviceDescription;
            localConfig.serviceName = serviceName;
            localConfig.listeners = listeners;
            localConfig.ownerHandle = GlobalConfigurations.User_Handle;
            localConfig.repoID = repoID;
            localConfig.type = type;
            localConfig.LHSProxyAddress = GlobalConfigurations.LHS_Address;
            localConfig.certPassword = GlobalConfigurations.certPassword;
            localConfig.certPath = GlobalConfigurations.certPath;
            try {
                localConfig.save(configFilePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Mp3Repository.init();
            DoipServiceInfo info = new DoipServiceInfo(localConfig.repoID, localConfig.ownerHandle, localConfig.type, (List)new Gson().fromJson(localConfig.listeners, new TypeToken<List<DoipListenerInfo>>(){}.getType()));
            info.serviceName = localConfig.serviceName;
            info.serviceDescription = localConfig.serviceDescription;
            DoipServiceHandleRecord repoHR = info.toServiceHandleRecord();
            logger.debug(new Gson().toJson(repoHR));
            if (repoHR.handle == null || repoHR.handle.equals("")) {
                String newHandle = GlobalIrpClient.getGlobalClient().register(repoHR);
                logger.info("[HandleService] response from LHS: " + newHandle);
                localConfig.repoID = info.id = newHandle;
            } else {
                String LHSResp = GlobalIrpClient.getGlobalClient().reRegister(repoHR);
                logger.info("[HandleService] response from LHS: " + LHSResp);
            }
            DoipServer server = DoipServerImpl.createDoipServer(info);
            StreamRepositoryHandler repositoryHandler = new StreamRepositoryHandler(info);
            server.setRepositoryHandler(repositoryHandler);
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() throws Exception {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        GlobalCertifications.loadKeysFromJKS(GlobalConfigurations.certPath, GlobalConfigurations.certPassword);
        GlobalIrpClient.useInternalIrpClient(GlobalCertifications.localKeypair, GlobalConfigurations.User_Handle, GlobalConfigurations.LHS_Address);
    }
}

