/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.DynamicMap;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

abstract class AbstractSortScript
implements ScorerAware {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(DynamicMap.class));
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = org.elasticsearch.common.collect.Map.of((Object)"doc", value -> {
        deprecationLogger.deprecatedAndMaybeLog("sort-script_doc", "Accessing variable [doc] via [params.doc] from within an sort-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, (Object)"_doc", value -> {
        deprecationLogger.deprecatedAndMaybeLog("sort-script__doc", "Accessing variable [doc] via [params._doc] from within an sort-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, (Object)"_source", value -> ((SourceLookup)value).loadSourceIfNeeded());
    private final Map<String, Object> params;
    private Scorable scorer;
    private final LeafSearchLookup leafLookup;

    AbstractSortScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
        HashMap<String, Object> parameters = new HashMap<String, Object>(params);
        parameters.putAll(this.leafLookup.asMap());
        this.params = new DynamicMap(parameters, PARAMS_FUNCTIONS);
    }

    protected AbstractSortScript() {
        this.params = null;
        this.leafLookup = null;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setScorer(Scorable scorer) {
        this.scorer = scorer;
    }

    public double get_score() {
        try {
            return this.scorer.score();
        }
        catch (IOException e) {
            throw new ElasticsearchException("couldn't lookup score", (Throwable)e, new Object[0]);
        }
    }

    public Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }
}

