/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BoostAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.termvectors.TermVectorsFields;
import org.elasticsearch.action.termvectors.TermVectorsFilter;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsWriter;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.dfs.AggregatedDfs;

public class TermVectorsResponse
extends ActionResponse
implements ToXContentObject {
    private BytesReference termVectors;
    private BytesReference headerRef;
    private String index;
    private String type;
    private String id;
    private long docVersion;
    private boolean exists = false;
    private boolean artificial = false;
    private long tookInMillis;
    private boolean hasScores = false;
    private boolean sourceCopied = false;
    int[] currentPositions = new int[0];
    int[] currentStartOffset = new int[0];
    int[] currentEndOffset = new int[0];
    BytesReference[] currentPayloads = new BytesReference[0];

    public TermVectorsResponse(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    TermVectorsResponse() {
    }

    TermVectorsResponse(StreamInput in) throws IOException {
        this.index = in.readString();
        this.type = in.readString();
        this.id = in.readString();
        this.docVersion = in.readVLong();
        this.exists = in.readBoolean();
        this.artificial = in.readBoolean();
        this.tookInMillis = in.readVLong();
        if (in.readBoolean()) {
            this.headerRef = in.readBytesReference();
            this.termVectors = in.readBytesReference();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeVLong(this.docVersion);
        boolean docExists = this.isExists();
        out.writeBoolean(docExists);
        out.writeBoolean(this.artificial);
        out.writeVLong(this.tookInMillis);
        out.writeBoolean(this.hasTermVectors());
        if (this.hasTermVectors()) {
            out.writeBytesReference(this.headerRef);
            out.writeBytesReference(this.termVectors);
        }
    }

    private boolean hasTermVectors() {
        assert (this.headerRef == null && this.termVectors == null || this.headerRef != null && this.termVectors != null);
        return this.headerRef != null;
    }

    public Fields getFields() throws IOException {
        if (this.hasTermVectors() && this.isExists()) {
            if (!this.sourceCopied) {
                this.headerRef = new BytesArray(this.headerRef.toBytesRef(), true);
                this.termVectors = new BytesArray(this.termVectors.toBytesRef(), true);
            }
            TermVectorsFields termVectorsFields = new TermVectorsFields(this.headerRef, this.termVectors);
            this.hasScores = termVectorsFields.hasScores;
            return termVectorsFields;
        }
        return new Fields(){

            public Iterator<String> iterator() {
                return Collections.emptyIterator();
            }

            public Terms terms(String field) throws IOException {
                return null;
            }

            public int size() {
                return 0;
            }
        };
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        assert (this.index != null);
        assert (this.type != null);
        assert (this.id != null);
        builder.startObject();
        builder.field("_index", this.index);
        builder.field("_type", this.type);
        if (!this.isArtificial()) {
            builder.field("_id", this.id);
        }
        builder.field("_version", this.docVersion);
        builder.field("found", this.isExists());
        builder.field("took", this.tookInMillis);
        if (this.isExists()) {
            builder.startObject("term_vectors");
            CharsRefBuilder spare = new CharsRefBuilder();
            Fields theFields = this.getFields();
            Iterator fieldIter = theFields.iterator();
            while (fieldIter.hasNext()) {
                this.buildField(builder, spare, theFields, fieldIter);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private void buildField(XContentBuilder builder, CharsRefBuilder spare, Fields theFields, Iterator<String> fieldIter) throws IOException {
        String fieldName = fieldIter.next();
        builder.startObject(fieldName);
        Terms curTerms = theFields.terms(fieldName);
        this.buildFieldStatistics(builder, curTerms);
        builder.startObject("terms");
        TermsEnum termIter = curTerms.iterator();
        BoostAttribute boostAtt = (BoostAttribute)termIter.attributes().addAttribute(BoostAttribute.class);
        int i = 0;
        while ((long)i < curTerms.size()) {
            this.buildTerm(builder, spare, curTerms, termIter, boostAtt);
            ++i;
        }
        builder.endObject();
        builder.endObject();
    }

    private void buildTerm(XContentBuilder builder, CharsRefBuilder spare, Terms curTerms, TermsEnum termIter, BoostAttribute boostAtt) throws IOException {
        BytesRef term = termIter.next();
        spare.copyUTF8Bytes(term);
        builder.startObject(spare.toString());
        this.buildTermStatistics(builder, termIter);
        PostingsEnum posEnum = termIter.postings(null, 120);
        int termFreq = posEnum.freq();
        builder.field("term_freq", termFreq);
        this.initMemory(curTerms, termFreq);
        this.initValues(curTerms, posEnum, termFreq);
        this.buildValues(builder, curTerms, termFreq);
        this.buildScore(builder, boostAtt);
        builder.endObject();
    }

    private void buildTermStatistics(XContentBuilder builder, TermsEnum termIter) throws IOException {
        assert (termIter.docFreq() > 0 && termIter.totalTermFreq() > 0L || termIter.docFreq() == -1 && termIter.totalTermFreq() == -1L);
        int docFreq = termIter.docFreq();
        if (docFreq > 0) {
            builder.field("doc_freq", docFreq);
            builder.field("ttf", termIter.totalTermFreq());
        }
    }

    private void buildValues(XContentBuilder builder, Terms curTerms, int termFreq) throws IOException {
        if (!(curTerms.hasPayloads() || curTerms.hasOffsets() || curTerms.hasPositions())) {
            return;
        }
        builder.startArray("tokens");
        for (int i = 0; i < termFreq; ++i) {
            builder.startObject();
            if (curTerms.hasPositions()) {
                builder.field("position", this.currentPositions[i]);
            }
            if (curTerms.hasOffsets()) {
                builder.field("start_offset", this.currentStartOffset[i]);
                builder.field("end_offset", this.currentEndOffset[i]);
            }
            if (curTerms.hasPayloads() && this.currentPayloads[i].length() > 0) {
                BytesRef bytesRef = this.currentPayloads[i].toBytesRef();
                builder.field("payload", bytesRef.bytes, bytesRef.offset, bytesRef.length);
            }
            builder.endObject();
        }
        builder.endArray();
    }

    private void initValues(Terms curTerms, PostingsEnum posEnum, int termFreq) throws IOException {
        for (int j = 0; j < termFreq; ++j) {
            int nextPos = posEnum.nextPosition();
            if (curTerms.hasPositions()) {
                this.currentPositions[j] = nextPos;
            }
            if (curTerms.hasOffsets()) {
                this.currentStartOffset[j] = posEnum.startOffset();
                this.currentEndOffset[j] = posEnum.endOffset();
            }
            if (!curTerms.hasPayloads()) continue;
            BytesRef curPayload = posEnum.getPayload();
            this.currentPayloads[j] = curPayload != null ? new BytesArray(curPayload.bytes, 0, curPayload.length) : null;
        }
    }

    private void initMemory(Terms curTerms, int termFreq) {
        if (curTerms.hasPositions()) {
            this.currentPositions = ArrayUtil.grow((int[])this.currentPositions, (int)termFreq);
        }
        if (curTerms.hasOffsets()) {
            this.currentStartOffset = ArrayUtil.grow((int[])this.currentStartOffset, (int)termFreq);
            this.currentEndOffset = ArrayUtil.grow((int[])this.currentEndOffset, (int)termFreq);
        }
        if (curTerms.hasPayloads()) {
            this.currentPayloads = new BytesArray[termFreq];
        }
    }

    private void buildFieldStatistics(XContentBuilder builder, Terms curTerms) throws IOException {
        long sumDocFreq = curTerms.getSumDocFreq();
        int docCount = curTerms.getDocCount();
        long sumTotalTermFrequencies = curTerms.getSumTotalTermFreq();
        if (docCount >= 0) {
            assert (sumDocFreq >= 0L) : "docCount >= 0 but sumDocFreq ain't!";
            assert (sumTotalTermFrequencies >= 0L) : "docCount >= 0 but sumTotalTermFrequencies ain't!";
            builder.startObject("field_statistics");
            builder.field("sum_doc_freq", sumDocFreq);
            builder.field("doc_count", docCount);
            builder.field("sum_ttf", sumTotalTermFrequencies);
            builder.endObject();
        } else if (docCount == -1) {
            assert (sumDocFreq == -1L) : "docCount was -1 but sumDocFreq ain't!";
            assert (sumTotalTermFrequencies == -1L) : "docCount was -1 but sumTotalTermFrequencies ain't!";
        } else {
            throw new IllegalStateException("Something is wrong with the field statistics of the term vector request: Values are \nsum_doc_freq " + sumDocFreq + "\n" + "doc_count" + " " + docCount + "\n" + "sum_ttf" + " " + sumTotalTermFrequencies);
        }
    }

    public void setTookInMillis(long tookInMillis) {
        this.tookInMillis = tookInMillis;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    private void buildScore(XContentBuilder builder, BoostAttribute boostAtt) throws IOException {
        if (this.hasScores) {
            builder.field("score", boostAtt.getBoost());
        }
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public void setFields(Fields termVectorsByField, Set<String> selectedFields, EnumSet<TermVectorsRequest.Flag> flags, Fields topLevelFields) throws IOException {
        this.setFields(termVectorsByField, selectedFields, flags, topLevelFields, null, null);
    }

    public void setFields(Fields termVectorsByField, Set<String> selectedFields, EnumSet<TermVectorsRequest.Flag> flags, Fields topLevelFields, @Nullable AggregatedDfs dfs, TermVectorsFilter termVectorsFilter) throws IOException {
        TermVectorsWriter tvw = new TermVectorsWriter(this);
        if (termVectorsByField != null) {
            tvw.setFields(termVectorsByField, selectedFields, flags, topLevelFields, dfs, termVectorsFilter);
        }
    }

    public void setTermVectorsField(BytesStreamOutput output) {
        this.termVectors = output.bytes();
    }

    public void setHeader(BytesReference header) {
        this.headerRef = header;
    }

    public void setDocVersion(long version) {
        this.docVersion = version;
    }

    public Long getVersion() {
        return this.docVersion;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public boolean isArtificial() {
        return this.artificial;
    }

    public void setArtificial(boolean artificial) {
        this.artificial = artificial;
    }

    private static class FieldStrings {
        public static final String TTF = "ttf";
        public static final String DOC_FREQ = "doc_freq";
        public static final String TERM_FREQ = "term_freq";
        public static final String SCORE = "score";
        public static final String FIELD_STATISTICS = "field_statistics";
        public static final String DOC_COUNT = "doc_count";
        public static final String SUM_DOC_FREQ = "sum_doc_freq";
        public static final String SUM_TTF = "sum_ttf";
        public static final String TOKENS = "tokens";
        public static final String POS = "position";
        public static final String START_OFFSET = "start_offset";
        public static final String END_OFFSET = "end_offset";
        public static final String PAYLOAD = "payload";
        public static final String _INDEX = "_index";
        public static final String _TYPE = "_type";
        public static final String _ID = "_id";
        public static final String _VERSION = "_version";
        public static final String FOUND = "found";
        public static final String TOOK = "took";
        public static final String TERMS = "terms";
        public static final String TERM_VECTORS = "term_vectors";

        private FieldStrings() {
        }
    }
}

