/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipClient;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import org.bdware.doip.core.codec.DelimiterMessageClientCodec;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.doipClient.NettyDoipClientChannel;
import org.bdware.doip.endpoint.doipClient.NettyDoipClientHandler;

public class NettyDoipTlsClientChannel
extends NettyDoipClientChannel {
    private static final byte[] EOF = new byte[]{10, 35, 10, 35, 10};
    EventLoopGroup group;

    protected SslContext getSSLContext() throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(GlobalCertifications.getGlobalKeyStore(), GlobalConfigurations.certPassword.toCharArray());
        SslContext sslCtx = SslContextBuilder.forClient().keyManager(keyManagerFactory).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        return sslCtx;
    }

    @Override
    public void close() {
        if (this.handler != null) {
            this.handler.close();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
        this.remoteAddress = null;
        this.isConnected = false;
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException {
        URI uri = new URI(targetUrl);
        logger.debug((Object)("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort()));
        Bootstrap b = new Bootstrap();
        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
        this.group = new NioEventLoopGroup();
        b.group(this.group);
        this.handler = new NettyDoipClientHandler();
        ((Bootstrap)((Bootstrap)b.channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                SSLEngine engine = NettyDoipTlsClientChannel.this.getSSLContext().newEngine(ch.alloc());
                ch.pipeline().addFirst(new ChannelHandler[]{new SslHandler(engine)}).addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(GlobalConfigurations.defaultMsgMTU, Unpooled.copiedBuffer((byte[])EOF))}).addLast(new ChannelHandler[]{new DelimiterMessageClientCodec()}).addLast(new ChannelHandler[]{NettyDoipTlsClientChannel.this.handler});
            }
        });
        logger.debug((Object)"[DoipClient] Create TLS Client!");
        try {
            logger.debug((Object)("[URI Parse]host: " + uri.getHost() + "  port: " + uri.getPort()));
            this.channel = b.connect(uri.getHost(), uri.getPort()).sync().channel();
            this.handler.setChannel(this.channel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isConnected = true;
    }
}

