/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipClient;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.ssl.SslHandler;
import java.util.Random;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bdware.doip.core.crypto.CertUtils;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.endpoint.doipClient.DoipMessageCallback;
import org.bdware.doip.endpoint.doipClient.SyncResult;

@ChannelHandler.Sharable
public class NettyDoipClientHandler
extends SimpleChannelInboundHandler<DoipMessage> {
    static Logger logger = Logger.getLogger(NettyDoipClientHandler.class);
    public Channel channel;
    SyncResult sync = new SyncResult();
    Random random = new Random();

    public void sendMessage(DoipMessage request, DoipMessageCallback callback) {
        if (callback == null) {
            logger.error((Object)"DoMessageCallback is null, please check!");
        }
        if (request.requestID == 0) {
            request.requestID = this.random.nextInt();
        }
        this.channel.writeAndFlush((Object)request);
        this.sync.sleep(request.requestID, callback);
    }

    public void close() {
        this.channel.close();
    }

    public void setChannel(Channel c) {
        this.channel = c;
    }

    protected void channelRead0(ChannelHandlerContext ctx, DoipMessage msg) {
        logger.debug((Object)"channelRead0 receive a message");
        if (msg.header.isCertified()) {
            try {
                if (!GlobalCertifications.verifyDoipMessage(msg)) {
                    logger.warn((Object)"verification failed");
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.sync.wakeUp(msg.requestID, msg);
        ctx.close();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (ctx.pipeline().get(SslHandler.class) != null) {
            ((SslHandler)ctx.pipeline().get(SslHandler.class)).handshakeFuture().addListener(future -> {
                if (future.isSuccess()) {
                    logger.debug((Object)"TLS connection established");
                    SSLSession ss = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession();
                    X509Certificate cert = ss.getPeerCertificateChain()[0];
                    String info = CertUtils.encodeKey(cert.getPublicKey());
                    logger.debug((Object)("PublicKey:" + info));
                    info = cert.getSubjectDN().getName();
                    logger.debug((Object)("Certification Owner:" + info));
                    info = cert.getIssuerDN().getName();
                    logger.debug((Object)("Certification Issuer:" + info));
                    info = cert.getSigAlgName();
                    logger.debug((Object)("Sign Algorithm:" + info));
                } else {
                    logger.info((Object)"TLS connection established failed");
                }
            });
        }
    }
}

