/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.codec.packet;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.bdware.doip.core.codec.packet.AbstractEnvelopeReceiveBuffer;
import org.bdware.doip.core.doipMessage.MessageEnvelope;
import org.bdware.doip.core.exception.EnvelopeResendException;

public class NoResendEnvelopeReveiveBuffer
extends AbstractEnvelopeReceiveBuffer {
    HashMap<Integer, MessageEnvelope> envMap;
    int totalNumber;
    TreeSet<Integer> sortedPacketNumberSet = new TreeSet();

    public NoResendEnvelopeReveiveBuffer(int requestId, ChannelHandlerContext ctx) {
        super(requestId, ctx);
        this.envMap = new HashMap();
    }

    @Override
    public boolean isCompleted() {
        return this.totalNumber <= this.envMap.size();
    }

    @Override
    public int addEnvelope(MessageEnvelope envelope) throws EnvelopeResendException {
        if (this.totalNumber == 0) {
            this.totalNumber = envelope.totalNumber;
        }
        this.envMap.put(envelope.sequenceNumber, envelope);
        this.sortedPacketNumberSet.add(envelope.sequenceNumber);
        return this.totalNumber - envelope.sequenceNumber - 1;
    }

    @Override
    public ArrayList<MessageEnvelope> getSortedEnvelopes() {
        ArrayList<MessageEnvelope> envelopes = new ArrayList<MessageEnvelope>();
        for (int key : this.sortedPacketNumberSet) {
            envelopes.add(this.envMap.get(key));
        }
        return envelopes;
    }
}

