/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.ssl.SslHandler;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.log4j.Logger;
import org.bdware.doip.core.codec.DelimiterMessageCodec;
import org.bdware.doip.core.codec.DelimiterMessageCodecImpl;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.exception.DoDecodeException;
import org.bdware.doip.core.utils.GlobalConfigurations;

@ChannelHandler.Sharable
public class DelimiterMessageClientCodec
extends MessageToMessageCodec<ByteBuf, DoipMessage> {
    private static Logger logger = Logger.getLogger(DelimiterMessageClientCodec.class);
    DelimiterMessageCodec codec = new DelimiterMessageCodecImpl();

    protected void encode(ChannelHandlerContext ctx, DoipMessage msg, List<Object> out) {
        try {
            logger.debug((Object)"client encode message");
            ByteBuf buff = Unpooled.directBuffer();
            byte[] reqBytes = this.codec.RequestToBytes(msg);
            buff.writeBytes(reqBytes);
            logger.info((Object)("client sending message: " + new String(reqBytes)));
            out.add(buff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        try {
            logger.debug((Object)"client decode message");
            SSLSession ss = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession();
            X509Certificate cert = null;
            try {
                Certificate[] certificates = ss.getPeerCertificates();
                cert = (X509Certificate)certificates[certificates.length - 1];
            }
            catch (SSLPeerUnverifiedException e) {
                e.printStackTrace();
            }
            String serviceId = cert.getSubjectDN().getName().replace("UID=", "");
            logger.debug((Object)("service subject: " + serviceId));
            PublicKey publicKey = cert.getPublicKey();
            byte[] responseBytes = new byte[msg.readableBytes()];
            msg.readBytes(responseBytes);
            if (!serviceId.equals(GlobalConfigurations.DoipServiceID)) {
                logger.error((Object)String.format("service identifier inconsistent with certificate, expect service id: %s, certificate subject: %s", GlobalConfigurations.DoipServiceID, serviceId));
            } else if (GlobalConfigurations.enableIRP && !publicKey.equals(GlobalConfigurations.servicePkFromIRP)) {
                logger.error((Object)String.format("service public key inconsistent with certificate, expect service public key: %s, certificate public key: %s", GlobalConfigurations.servicePkFromIRP.toString(), publicKey.toString()));
            } else {
                logger.info((Object)("client received message: " + new String(responseBytes)));
            }
            DoipMessage inMsg = this.codec.BytesToResponse(responseBytes);
            out.add(inMsg);
        }
        catch (DoDecodeException e) {
            e.printStackTrace();
        }
    }
}

