/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.application;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.doip.application.DoipServiceConfig;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.DoType;
import org.bdware.doip.core.model.handleRecord.DoipServiceHandleRecord;
import org.bdware.doip.core.utils.GlobalConfigurations;
import org.bdware.doip.endpoint.doipServer.DoipListenerInfo;
import org.bdware.doip.endpoint.doipServer.DoipServer;
import org.bdware.doip.endpoint.doipServer.DoipServerImpl;
import org.bdware.doip.endpoint.doipServer.DoipServiceInfo;
import org.bdware.doip.endpoint.irpClient.GlobalIrpClient;
import org.bdware.doip.implementation.DoStorage;
import org.bdware.doip.implementation.DoStorageRocksDBImpl;
import org.bdware.doip.implementation.SimpleRepositoryHandler;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SimpleRepositoryMain {
    static Logger logger = Logger.getLogger(SimpleRepositoryMain.class);
    static final String configFilePath = "default_repo.json";
    public static String listeners = "[{\"url\":\"tls://127.0.0.1:1720\",\"protocolVersion\":\"2.0\",\"messageFormat\":\"delimiter\"}]";
    public static String repoID = "86.5000.470/doip.localTlsRepo";
    public static String serviceDescription = "test local TLS Repository";
    public static String serviceName = "TestTLS";
    public static String type;
    public static DoStorage doStorage;
    public static DoipServiceConfig localConfig;

    public static void main(String[] args) {
        localConfig = DoipServiceConfig.loadFromConfigFile(configFilePath);
        if (localConfig != null && SimpleRepositoryMain.localConfig.listeners != null && !SimpleRepositoryMain.localConfig.listeners.equals("")) {
            if (SimpleRepositoryMain.localConfig.LHSProxyAddress != null) {
                GlobalConfigurations.LHS_Address = SimpleRepositoryMain.localConfig.LHSProxyAddress;
            }
            if (SimpleRepositoryMain.localConfig.ownerHandle != null) {
                GlobalConfigurations.User_Handle = SimpleRepositoryMain.localConfig.ownerHandle;
            }
            if (SimpleRepositoryMain.localConfig.certPath != null) {
                GlobalConfigurations.certPath = SimpleRepositoryMain.localConfig.certPath;
            }
            if (SimpleRepositoryMain.localConfig.certPassword != null) {
                GlobalConfigurations.certPassword = SimpleRepositoryMain.localConfig.certPassword;
            }
        } else {
            logger.info((Object)"cannot find config file, using static config");
            localConfig = new DoipServiceConfig();
            SimpleRepositoryMain.localConfig.serviceDescription = serviceDescription;
            SimpleRepositoryMain.localConfig.serviceName = serviceName;
            SimpleRepositoryMain.localConfig.listeners = listeners;
            SimpleRepositoryMain.localConfig.ownerHandle = GlobalConfigurations.User_Handle;
            SimpleRepositoryMain.localConfig.repoID = repoID;
            SimpleRepositoryMain.localConfig.type = type;
            SimpleRepositoryMain.localConfig.LHSProxyAddress = GlobalConfigurations.LHS_Address;
            SimpleRepositoryMain.localConfig.certPassword = GlobalConfigurations.certPassword;
            SimpleRepositoryMain.localConfig.certPath = GlobalConfigurations.certPath;
        }
        try {
            SimpleRepositoryMain.init();
            DoipServiceInfo info = new DoipServiceInfo(SimpleRepositoryMain.localConfig.repoID, SimpleRepositoryMain.localConfig.ownerHandle, SimpleRepositoryMain.localConfig.type, (List)new Gson().fromJson(SimpleRepositoryMain.localConfig.listeners, new TypeToken<List<DoipListenerInfo>>(){}.getType()));
            info.serviceName = SimpleRepositoryMain.localConfig.serviceName;
            info.serviceDescription = SimpleRepositoryMain.localConfig.serviceDescription;
            DoipServiceHandleRecord repoHR = info.toServiceHandleRecord();
            logger.debug((Object)new Gson().toJson((Object)repoHR));
            if (repoHR.handle == null || repoHR.handle.equals("")) {
                String newHandle = GlobalIrpClient.getGlobalClient().register(repoHR);
                logger.info((Object)("[HandleService] response from LHS: " + newHandle));
                SimpleRepositoryMain.localConfig.repoID = info.id = newHandle;
                repoHR.handle = newHandle;
                repoHR.setRepository();
                String LHSResp = GlobalIrpClient.getGlobalClient().reRegister(repoHR);
                logger.info((Object)("[HandleService] response from LHS: " + LHSResp));
            } else {
                repoHR.setRepository();
                String LHSResp = GlobalIrpClient.getGlobalClient().reRegister(repoHR);
                logger.info((Object)("[HandleService] response from LHS: " + LHSResp));
            }
            DoipServer server = DoipServerImpl.createDoipServer(info);
            doStorage = new DoStorageRocksDBImpl();
            SimpleRepositoryMain.initialUserAccount();
            server.setRepositoryHandler(new SimpleRepositoryHandler(info, doStorage));
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() throws Exception {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        GlobalCertifications.loadKeysFromJKS(GlobalConfigurations.certPath, GlobalConfigurations.certPassword);
        GlobalIrpClient.useInternalIrpClient(GlobalCertifications.localKeypair, GlobalConfigurations.User_Handle, GlobalConfigurations.LHS_Address);
    }

    public static void initialUserAccount() {
        if (doStorage.getDoByID(SimpleRepositoryMain.localConfig.repoID) == null) {
            try {
                String account = SimpleRepositoryMain.readFile("account.json");
                Account accountObj = (Account)new Gson().fromJson(account, Account.class);
                DigitalObject digitalObject = new DigitalObject(SimpleRepositoryMain.localConfig.repoID, DoType.User);
                digitalObject.addAttribute("username", accountObj.userName);
                digitalObject.addAttribute("password", accountObj.userPass);
                doStorage.storeDo(digitalObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String readFile(String path) throws Exception {
        File file = new File(path);
        logger.debug((Object)("conf file absolute path: " + file.getAbsolutePath()));
        StringBuilder configJson = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        while (line != null) {
            configJson.append(line);
            line = br.readLine();
        }
        br.close();
        return configJson.toString();
    }

    public class Account {
        String userName;
        String userPass;
    }
}

