/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.implementation;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.http.HttpHost;
import org.apache.log4j.Logger;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.metadata.SearchParameter;
import org.bdware.doip.core.model.metadata.SearchResult;
import org.bdware.doip.core.utils.DoipGson;
import org.bdware.doip.implementation.DoIndexer;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.MainResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class DoIndexerESImpl
implements DoIndexer {
    public RestHighLevelClient client;
    public String indexName;
    public RequestOptions requestOptions;
    public IndexRequest request;
    Logger logger = Logger.getLogger(DoIndexerESImpl.class);

    public DoIndexerESImpl(String indexName, String url) throws URISyntaxException {
        URI uri = new URI(url);
        this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme())}));
        this.indexName = indexName;
        this.requestOptions = RequestOptions.DEFAULT;
        this.request = new IndexRequest(indexName);
        try {
            MainResponse response = this.client.info(this.requestOptions);
            String version = response.getVersion().getNumber();
            this.logger.info((Object)("target es version: " + version));
            GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
            if (!this.client.indices().exists(request, this.requestOptions)) {
                this.initializeIndex();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean indexDigitalObject(DigitalObject doc) throws IOException {
        String json = DoipGson.getDoipGson().toJson((Object)doc);
        this.request.id(doc.id);
        this.request.type("_doc");
        this.request.source(json, XContentType.JSON);
        IndexResponse indexResponse = this.client.index(this.request, this.requestOptions);
        return indexResponse.getResult().equals((Object)DocWriteResponse.Result.CREATED);
    }

    @Override
    public boolean indexJson(String handle, String doc) throws IOException {
        String json = doc;
        this.request.id(handle);
        this.request.type("_doc");
        this.request.source(json, XContentType.JSON);
        IndexResponse indexResponse = this.client.index(this.request, this.requestOptions);
        return indexResponse.getResult().equals((Object)DocWriteResponse.Result.CREATED);
    }

    @Override
    public SearchResult search(SearchParameter searchParameter) throws IOException {
        if (searchParameter == null) {
            searchParameter = SearchParameter.getDefaultParameter();
        }
        int size = searchParameter.pageSize;
        int from = searchParameter.pageNum == 0 || searchParameter.pageSize <= 0 ? 0 : searchParameter.pageNum * searchParameter.pageSize;
        if (searchParameter.pageSize < 0) {
            size = 500;
        }
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)searchParameter.query);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder).from(from).trackTotalHits(true).explain(Boolean.valueOf(false)).size(size);
        if (searchParameter.type.equals("id")) {
            searchSourceBuilder.fetchSource(false);
        } else {
            searchSourceBuilder.fetchSource(true);
        }
        searchSourceBuilder.storedFields(Arrays.asList("type.raw", "type"));
        int i = 0;
        if (i < searchParameter.sortFields.size()) {
            searchSourceBuilder.sort("_id", SortOrder.DESC);
        }
        SearchRequest request = new SearchRequest(new String[]{this.indexName});
        request.searchType(SearchType.DFS_QUERY_THEN_FETCH);
        request.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(request, this.requestOptions);
        this.logger.info((Object)("search response: " + searchResponse.toString()));
        SearchHit[] hits = searchResponse.getInternalResponse().hits().getHits();
        SearchResult searchResult = new SearchResult();
        searchResult.size = hits.length;
        this.logger.info((Object)("hits size:" + hits.length));
        for (SearchHit hit : hits) {
            this.logger.info((Object)("search res docid:" + hit.getId()));
            String tmp = hit.getSourceAsString();
            if (tmp == null) {
                tmp = hit.getId();
                searchResult.addItem(tmp);
                continue;
            }
            JsonObject jsonObject = JsonParser.parseString((String)tmp).getAsJsonObject();
            searchResult.addItem(jsonObject);
        }
        return searchResult;
    }

    @Override
    public boolean deleteDigitalObject(String id) {
        DeleteRequest deleteRequest = new DeleteRequest(this.indexName);
        deleteRequest.id(id);
        deleteRequest.type("_doc");
        try {
            this.client.delete(deleteRequest, this.requestOptions);
        }
        catch (Exception e) {
            this.logger.error((Object)"error on deleting digital object");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void initializeIndex() throws IOException {
        this.logger.info((Object)"Initializing Elasticsearch index.");
        CreateIndexRequest request = new CreateIndexRequest(this.indexName);
        CreateIndexResponse response = this.client.indices().create(request, this.requestOptions);
        if (!response.isAcknowledged()) {
            this.logger.error((Object)"Create index response not acknowledged.");
        } else {
            this.logger.info((Object)"Create index response: acknowledged.");
        }
    }
}

