/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.model.metadata;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class SearchParameter {
    public String query;
    public int pageNum;
    public int pageSize;
    public List<SortField> sortFields;
    public String sortFieldsSer;
    public String type;
    Logger logger = Logger.getLogger(SearchParameter.class);

    public SearchParameter(String query, int pageNum, int pageSize, String sortFields, String type) {
        String[] sortFieldRes;
        LinkedList<SortField> sortFieldList = new LinkedList<SortField>();
        for (String sortField : sortFieldRes = sortFields.split(",")) {
            this.logger.debug((Object)("sort field: " + sortField));
            String[] tmpRes = sortField.split(":");
            if (tmpRes.length != 1 && tmpRes.length != 2) {
                this.logger.error((Object)"wrong sort fields");
                continue;
            }
            if (tmpRes[0].equals("")) {
                this.logger.error((Object)"sort field is empty, ignore");
                continue;
            }
            SortField tmp = new SortField();
            tmp.item = tmpRes[0];
            if (tmpRes.length == 1) {
                this.logger.warn((Object)"no asc or desc specified, use asc for default");
                tmp.order = "ASC";
            } else if (tmpRes[1].equals("")) {
                this.logger.warn((Object)"no asc or desc specified, use asc for default");
                tmp.order = "ASC";
            } else {
                tmp.order = tmpRes[1];
            }
            this.logger.debug((Object)("item: " + tmp.item));
            this.logger.debug((Object)("order: " + tmp.order));
            sortFieldList.add(tmp);
        }
        this.logger.info((Object)("sort field size: " + sortFieldList.size()));
        this.query = query;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.sortFields = sortFieldList;
        this.type = type;
        this.sortFieldsSer = sortFields;
    }

    public static SearchParameter getDefaultParameter() {
        return new SearchParameter("", 0, -1, "", "");
    }

    public class SortField {
        public String item;
        public String order;
    }
}

