/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.crypto.signature;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedList;

public class Utils {
    public static String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    public static String encodeHexString(byte[] byteArray) {
        StringBuffer hexStringBuffer = new StringBuffer();
        for (int i = 0; i < byteArray.length; ++i) {
            hexStringBuffer.append(Utils.byteToHex(byteArray[i]));
        }
        return hexStringBuffer.toString();
    }

    public static String urlSafeEncode(byte[] data) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(data);
    }

    public static byte[] urlSafeDecode(byte[] data) {
        return Base64.getUrlDecoder().decode(data);
    }

    public static byte[] preprocess(byte[] rawPayload) throws NoSuchAlgorithmException {
        LinkedList<byte[]> res = new LinkedList<byte[]>();
        int cursor = 0;
        int length = 0;
        for (int i = 0; i < rawPayload.length - 1; ++i) {
            if (rawPayload[i] == 35 && rawPayload[i + 1] == 10) {
                byte[] tmpRes = new byte[length + 2];
                System.arraycopy(rawPayload, cursor, tmpRes, 0, length + 2);
                res.add(tmpRes);
                cursor += length + 2;
                length = 0;
                ++i;
                continue;
            }
            ++length;
        }
        int totalLength = 0;
        for (int i = 0; i < res.size(); ++i) {
            byte[] tmpBytes = (byte[])res.get(i);
            if (tmpBytes[0] == 64 && tmpBytes[1] == 10) {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                tmpBytes = Arrays.copyOf(tmpBytes, tmpBytes.length - 2);
                md.update(tmpBytes);
                byte[] mdRes = md.digest();
                mdRes = Arrays.copyOf(mdRes, mdRes.length + 2);
                mdRes[mdRes.length - 2] = 35;
                mdRes[mdRes.length - 1] = 10;
                res.set(i, mdRes);
            }
            totalLength += ((byte[])res.get(i)).length;
        }
        byte[] finalResult = new byte[totalLength];
        cursor = 0;
        for (int i = 0; i < res.size(); ++i) {
            byte[] tmpBytes = (byte[])res.get(i);
            System.arraycopy(tmpBytes, 0, finalResult, cursor, tmpBytes.length);
            cursor += tmpBytes.length;
        }
        if (finalResult.length == 0) {
            finalResult = rawPayload;
        }
        return finalResult;
    }
}

