/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.implementation;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipResponseCode;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.DoType;
import org.bdware.doip.core.model.digitalObject.Element;
import org.bdware.doip.core.model.metadata.SearchParameter;
import org.bdware.doip.core.model.metadata.SearchResult;
import org.bdware.doip.core.utils.DoipGson;
import org.bdware.doip.endpoint.doipServer.DoipServiceInfo;
import org.bdware.doip.endpoint.doipServer.RegistryHandlerBase;
import org.bdware.doip.implementation.DoIndexer;
import org.bdware.doip.implementation.DoStorage;
import org.bdware.doip.implementation.SimpleRepositoryHandler;

public class SimpleRegistryHandler
extends RegistryHandlerBase {
    Logger logger = Logger.getLogger(SimpleRepositoryHandler.class);
    DoStorage store;
    DoIndexer indexer;

    public SimpleRegistryHandler(DoipServiceInfo info, DoStorage s, DoIndexer i) {
        super(info);
        this.serviceInfo = info;
        this.store = s;
        this.indexer = i;
    }

    @Override
    public DoipMessage handleHello(DoipMessage request) {
        return this.replyDoipServiceInfo(request);
    }

    @Override
    public DoipMessage handleListOps(DoipMessage request) {
        return this.replyAllOperations(request);
    }

    @Override
    public DoipMessage handleCreate(DoipMessage request) {
        try {
            DigitalObject digitalObject = request.body.getDataAsDigitalObject();
            if (digitalObject.type != DoType.Metadata) {
                return this.replyStringWithStatus(request, "Invalid DO Type: Only 0.TYPE/DO.Metadata is accepted.", DoipResponseCode.Invalid);
            }
            if (!request.header.parameters.id.equals(this.serviceInfo.id)) {
                return this.replyStringWithStatus(request, "Wrong operation targetID, should be: " + this.serviceInfo.id, DoipResponseCode.Invalid);
            }
            DigitalObject ret = this.store.getDoByID(digitalObject.id);
            if (ret != null) {
                return this.replyStringWithStatus(request, "Failed: the metadata of this DO is already existed.", DoipResponseCode.DoAlreadyExist);
            }
            this.logger.debug("Message body length: " + request.body.getLength());
            this.logger.info("create DO identifier : " + digitalObject.id);
            this.store.storeDo(digitalObject);
            this.indexer.indexDigitalObject(digitalObject);
            if (digitalObject.elements != null) {
                for (Element e : digitalObject.elements) {
                    e.excludeData();
                }
            }
            return this.replyDO(request, digitalObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }

    @Override
    public DoipMessage handleUpdate(DoipMessage request) {
        try {
            DigitalObject digitalObject = request.body.getDataAsDigitalObject();
            if (!request.header.parameters.id.equals(digitalObject.id)) {
                return this.replyStringWithStatus(request, "Invalid request: different identifiers in DO and message header.", DoipResponseCode.Invalid);
            }
            DigitalObject ret = this.store.getDoByID(digitalObject.id);
            if (ret == null) {
                return this.replyStringWithStatus(request, "Failed: DO is not existed.", DoipResponseCode.DoNotFound);
            }
            this.store.updateDo(digitalObject);
            this.indexer.deleteDigitalObject(digitalObject.id);
            this.indexer.indexDigitalObject(digitalObject);
            if (digitalObject.elements != null) {
                for (Element e : digitalObject.elements) {
                    e.excludeData();
                }
            }
            return this.replyDO(request, digitalObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }

    @Override
    public DoipMessage handleDelete(DoipMessage request) {
        try {
            DigitalObject ret = this.store.getDoByID(request.header.parameters.id);
            if (ret == null) {
                return this.replyStringWithStatus(request, "Failed: DO is not existed.", DoipResponseCode.DoNotFound);
            }
            this.store.deleteDoByID(request.header.parameters.id);
            this.indexer.deleteDigitalObject(request.header.parameters.id);
            return this.replyNull(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }

    @Override
    public DoipMessage handleRetrieve(DoipMessage request) {
        try {
            DigitalObject ret = this.store.getDoByID(request.header.parameters.id);
            if (ret == null) {
                return this.replyStringWithStatus(request, "Failed: DO is not existed.", DoipResponseCode.DoNotFound);
            }
            if (request.header.parameters.attributes != null && request.header.parameters.attributes.has("element")) {
                for (Element e : ret.elements) {
                    if (!e.id.equals(request.header.parameters.attributes.get("element").getAsString())) continue;
                    return this.replyString(request, e.getData() == null ? "" : new String(e.getData()));
                }
                return this.replyStringWithStatus(request, "element not found: " + request.header.parameters.attributes.get("element"), DoipResponseCode.DoNotFound);
            }
            if (request.header.parameters.attributes == null || !request.header.parameters.attributes.has("includeElementData")) {
                this.logger.debug("clean element data");
                for (Element e : ret.elements) {
                    e.excludeData();
                }
            }
            return this.replyDO(request, ret);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.replyStringWithStatus(request, "Server Exception: " + e.getMessage(), DoipResponseCode.MoreThanOneErrors);
        }
    }

    @Override
    public DoipMessage handleUnknown(DoipMessage request) {
        return this.replyStringWithStatus(request, "Unsupported Operation!", DoipResponseCode.Declined);
    }

    @Override
    public DoipMessage handleSearch(DoipMessage request) {
        if (request.header.parameters.attributes == null) {
            this.logger.info("invalid search request: attributes not found");
            return this.replyStringWithStatus(request, "invalid search request: attributes not found.", DoipResponseCode.Invalid);
        }
        SearchParameter sp = new SearchParameter(request.header.parameters.attributes.get("query").getAsString(), !request.header.parameters.attributes.has("pageNum") ? 0 : request.header.parameters.attributes.get("pageNum").getAsInt(), !request.header.parameters.attributes.has("pageSize") ? 0 : request.header.parameters.attributes.get("pageSize").getAsInt(), !request.header.parameters.attributes.has("sortFields") ? "" : request.header.parameters.attributes.get("sortFields").getAsString(), !request.header.parameters.attributes.has("type") ? null : request.header.parameters.attributes.get("type").getAsString());
        try {
            SearchResult sr = this.indexer.search(sp);
            return this.replyString(request, DoipGson.getDoipGson().toJson(sr));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

