/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.doipServer;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.log4j.Logger;
import org.bdware.doip.core.codec.packet.PacketNettyUDPCodec;
import org.bdware.doip.endpoint.doipServer.NettyDoipListener;

public class NettyUDPDoipListener
extends NettyDoipListener {
    private final int port;
    static Logger logger = Logger.getLogger(NettyUDPDoipListener.class);
    private Channel ch;

    protected NettyUDPDoipListener(int port) {
        this.port = port;
    }

    @Override
    public void start() {
        if (this.handler == null) {
            logger.error("Handler not init yet! set handler first");
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group(bossGroup)).channel(NioDatagramChannel.class)).localAddress(this.port)).option(ChannelOption.SO_BROADCAST, true);
            b.handler(new ChannelInitializer<DatagramChannel>(){

                @Override
                protected void initChannel(DatagramChannel ch) throws Exception {
                    ch.pipeline().addLast(new PacketNettyUDPCodec()).addLast(NettyUDPDoipListener.this.handler);
                }
            });
            this.ch = b.bind().syncUninterruptibly().channel();
            logger.info("start at:" + this.port);
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
        this.ch.close();
    }
}

