/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.model.digitalObject;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.bdware.doip.core.model.digitalObject.DoType;
import org.bdware.doip.core.model.digitalObject.Element;
import org.bdware.doip.core.utils.DoipGson;

public class DigitalObject {
    public String id;
    public DoType type;
    public JsonObject attributes;
    public List<Element> elements;

    public DigitalObject(String id, DoType type) {
        this.id = id;
        this.type = type;
    }

    public synchronized void addAttribute(String name, String att) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.addProperty(name, att);
    }

    public synchronized void addAttribute(String name, Number att) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.addProperty(name, att);
    }

    public synchronized void addAttribute(String name, JsonElement att) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.add(name, att);
    }

    public void addElements(Element e) {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(e);
    }

    public boolean isSigned() {
        return this.attributes != null && this.attributes.has("isSigned");
    }

    public String toString() {
        for (Element e : this.elements) {
            if (e.getData() == null) continue;
            e.dataString = new String(e.getData());
        }
        return DoipGson.getDoipGson().toJson(this);
    }

    public void needSign() {
        this.addAttribute("isSigned", "true");
    }
}

