/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.crypto.signature;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.log4j.Logger;
import org.bdware.doip.core.crypto.signature.Utils;

public class JWS {
    @Expose
    public String payload;
    @Expose
    public Sig[] signatures;
    private String entityId;
    private PublicKey pubKey;
    private PrivateKey signingKey;
    private String algorithm;
    private String encoding = "UTF-8";
    Logger logger = Logger.getLogger(JWS.class);

    public JWS(String entity, byte[] inputPayload, String alg, PrivateKey key) {
        this.entityId = entity;
        this.signingKey = key;
        this.algorithm = alg;
        this.payload = Utils.urlSafeEncode(inputPayload);
        this.logger.debug(String.format("sign algorithm: %s", this.algorithm));
    }

    public String getPayload() {
        return this.payload;
    }

    public void setEntity(String id) {
        this.entityId = id;
    }

    public void setKey(PrivateKey key) {
        this.signingKey = key;
    }

    public void setPubKey(PublicKey key) {
        this.pubKey = key;
    }

    public void setPayload(String input) {
        this.payload = input;
    }

    public void setAlgorithm(String alg) {
        this.algorithm = alg;
    }

    public void sign() throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Sig sig = new Sig();
        Sig.Header header = new Sig.Header();
        header.kid = this.entityId;
        sig.header = header;
        Alg algo = new Alg();
        algo.alg = this.algorithm;
        sig.Protected = Utils.urlSafeEncode(new Gson().toJson((Object)algo, (Type)((Object)Alg.class)).getBytes(this.encoding));
        if (this.algorithm.equals("RS256")) {
            Signature signObj = Signature.getInstance("SHA256withRSA");
            signObj.initSign(this.signingKey);
            signObj.update((sig.Protected + "." + this.payload).getBytes(this.encoding));
            sig.signature = Utils.urlSafeEncode(signObj.sign());
            this.signatures = new Sig[]{sig};
        } else {
            this.logger.error(String.format("Unsupported signature algorithm: %s", this.algorithm));
            this.signatures = null;
        }
    }

    public boolean verify() throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        byte[] algByte = Utils.urlSafeDecode(this.signatures[0].Protected.getBytes());
        String alg = new String(algByte);
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        Alg algo = gson.fromJson(alg, Alg.class);
        this.algorithm = algo.alg;
        if (!this.algorithm.equals("RS256")) {
            this.logger.error(String.format("Unsupported signature algorithm: %s", this.algorithm));
            return false;
        }
        Signature signObj = Signature.getInstance("SHA256withRSA");
        String signInput = this.signatures[0].Protected + "." + this.payload;
        byte[] signature = Utils.urlSafeDecode(this.signatures[0].signature.getBytes());
        signObj.initVerify(this.pubKey);
        signObj.update(signInput.getBytes());
        return signObj.verify(signature);
    }

    public static class Alg {
        @Expose
        String alg;
    }

    public static class Sig {
        @Expose
        @SerializedName(value="protected")
        public String Protected;
        @Expose
        public Header header;
        @Expose
        public String signature;

        public static class Header {
            @Expose
            public String kid;
        }
    }
}

