/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.core.codec;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.bdware.doip.core.codec.DigitalObjectCodec;
import org.bdware.doip.core.crypto.GlobalCertifications;
import org.bdware.doip.core.crypto.signature.DOSignature;
import org.bdware.doip.core.exception.DoDecodeException;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.Element;
import org.bdware.doip.core.utils.DoipGson;
import org.bdware.doip.core.utils.GlobalConfigurations;

public class DigitalObjectCodecImpl
implements DigitalObjectCodec {
    Logger logger = Logger.getLogger(DigitalObjectCodecImpl.class);

    @Override
    public byte[] DoToByteArray(DigitalObject digitalObject) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bo);
        Gson gson = DoipGson.getDoipGson();
        String jsonSegments = gson.toJson(digitalObject);
        try {
            out.writeInt(jsonSegments.getBytes().length);
            out.write(jsonSegments.getBytes());
            if (digitalObject.elements != null) {
                digitalObject.elements = this.sortElement(digitalObject.elements);
                for (Element e : digitalObject.elements) {
                    if (e.getData() == null) continue;
                    assert (e.length == e.getData().length);
                    out.write(e.getData());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bo.toByteArray();
    }

    public List<Element> sortElement(List<Element> eles) {
        for (int i = 0; i < eles.size(); ++i) {
            for (int j = i + 1; j < eles.size(); ++j) {
                if (eles.get((int)i).id.compareTo(eles.get((int)j).id) <= 0) continue;
                Element temp = eles.get(i);
                eles.set(i, eles.get(j));
                eles.set(j, temp);
            }
        }
        return eles;
    }

    @Override
    public DigitalObject ByteArrayToDo(byte[] doBytes) throws DoDecodeException, IOException {
        if (doBytes == null) {
            return null;
        }
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(doBytes));
        int metaLen = input.readInt();
        if (metaLen > doBytes.length) {
            this.logger.info("invalid DO byte array");
            throw new DoDecodeException("invalid DO byte array");
        }
        byte[] content = new byte[metaLen];
        int eof = input.read(content);
        this.logger.debug("digital Object: " + new String(content));
        Gson gson = DoipGson.getDoipGson();
        DigitalObject d = gson.fromJson(new String(content), DigitalObject.class);
        if (d.elements == null || eof == -1 || input.available() == 0) {
            return d;
        }
        d.elements.sort(Comparator.comparing(o -> o.id));
        for (int i = 0; i < d.elements.size(); ++i) {
            if (input.available() < d.elements.get((int)i).length) {
                throw new DoDecodeException("Unexpected element data length");
            }
            byte[] data = new byte[d.elements.get((int)i).length];
            input.read(data);
            d.elements.get(i).setData(data);
        }
        return d;
    }

    @Override
    public ArrayList<byte[]> DoToSegments(DigitalObject digitalObject) {
        ArrayList<byte[]> segStrings = new ArrayList<byte[]>();
        segStrings.add(DoipGson.getDoipGson().toJson(digitalObject).getBytes());
        if (digitalObject.elements != null) {
            for (Element element : digitalObject.elements) {
                if (element.getData() == null) continue;
                JsonObject eid = new JsonObject();
                eid.addProperty("id", element.id);
                segStrings.add(DoipGson.getDoipGson().toJson(eid).getBytes());
                segStrings.add(element.getData() == null ? "".getBytes() : ("@\n" + element.getData().length + "\n" + new String(element.getData())).getBytes());
            }
        }
        if (digitalObject.isSigned()) {
            ByteBuf signPayload = Unpooled.directBuffer();
            for (byte[] seg : segStrings) {
                signPayload.writeBytes(seg);
            }
            byte[] byArray = new byte[signPayload.readableBytes()];
            signPayload.readBytes(byArray);
            try {
                DOSignature signature = new DOSignature("SHA-256", byArray, GlobalConfigurations.User_Handle, GlobalCertifications.getGlobalKeypair().getPrivate(), "RS256");
                segStrings.add(signature.createSegment().getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return segStrings;
    }

    @Override
    public DigitalObject SegmentsToDo(ArrayList<byte[]> segStrings) throws DoDecodeException {
        DigitalObject digitalObject;
        if (segStrings == null || segStrings.size() < 1) {
            this.logger.error("input segment string is empty");
            return null;
        }
        Iterator<byte[]> segIt = segStrings.iterator();
        String jsonSegment = new String(segIt.next());
        this.logger.debug("DO json segments: " + jsonSegment);
        try {
            digitalObject = DoipGson.getDoipGson().fromJson(jsonSegment, DigitalObject.class);
            if (digitalObject.id == null) {
                throw new DoDecodeException("not digital object segments");
            }
        }
        catch (Exception e) {
            throw new DoDecodeException("not digital object segments");
        }
        HashMap<String, byte[]> elementDataMap = new HashMap<String, byte[]>();
        int index = 0;
        while (segIt.hasNext() && digitalObject.elements != null && index < digitalObject.elements.size()) {
            String elementIDSeg = new String(segIt.next());
            JsonObject eid = new Gson().fromJson(elementIDSeg, JsonObject.class);
            String elementID = eid.get("id").getAsString();
            if (elementID == null) {
                this.logger.error("element id segments error: " + elementIDSeg);
                break;
            }
            if (!segIt.hasNext()) {
                this.logger.error("element data segments not found!");
                break;
            }
            byte[] elementDataSeg = segIt.next();
            BufferedReader br = new BufferedReader(new StringReader(new String(elementDataSeg)));
            String elementData = "";
            block7: while (true) {
                try {
                    String line;
                    while ((line = br.readLine()) != null && line.length() != 0) {
                        if (line.charAt(0) == '@') {
                            int chunkLength = Integer.parseInt(br.readLine());
                            char[] chunk = new char[chunkLength];
                            br.read(chunk, 0, chunkLength);
                            elementData = elementData + new String(chunk);
                            continue;
                        }
                        if (elementData.length() <= 0) break block7;
                        this.logger.error("invalid chunks");
                        break block7;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            if (elementData.length() > 0) {
                elementDataMap.put(elementID, elementData.getBytes());
                continue;
            }
            elementDataMap.put(elementID, elementDataSeg);
        }
        if (digitalObject.isSigned() && segIt.hasNext()) {
            String signatureSeg = new String(segIt.next());
            ByteBuf signPayload = Unpooled.directBuffer();
            for (int i = 0; i < segStrings.size() - 1; ++i) {
                signPayload.writeBytes(segStrings.get(i));
            }
            byte[] payloadBytes = new byte[signPayload.readableBytes()];
            signPayload.readBytes(payloadBytes);
            try {
                DOSignature doSignature = new DOSignature(payloadBytes, signatureSeg, digitalObject.attributes.get("publicKey").getAsString());
                if (!doSignature.verifySegment()) {
                    this.logger.warn("Verify signature error!");
                }
            }
            catch (Exception e) {
                this.logger.warn("Verify signature error!");
                e.printStackTrace();
                return digitalObject;
            }
        }
        if (segIt.hasNext()) {
            this.logger.warn("unexcepted segment");
        }
        if (digitalObject.elements != null) {
            for (Element e : digitalObject.elements) {
                e.setData((byte[])elementDataMap.get(e.id));
            }
        }
        return digitalObject;
    }
}

