/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.application.client;

import java.util.Scanner;
import org.apache.log4j.Logger;
import org.bdware.doip.application.client.DOAClient;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.DoType;
import org.bdware.doip.core.model.digitalObject.Element;
import org.bdware.doip.core.model.metadata.SearchParameter;
import org.bdware.doip.core.utils.DoipGson;

public class CMDClient {
    private static DOAClient client;
    public static final String certPath = "keys/dou.TEST.keystore";
    public static final String cerPWD = "123456";
    public static final String userHandle = "86.5000.470/dou.TEST";
    public static final String LHS_Address = "http://39.104.122.7:10001/";
    public static Logger logger;

    public static void main(String[] args) {
        DOAClient client = new DOAClient(certPath, cerPWD, userHandle, LHS_Address);
        Scanner reader = new Scanner(System.in);
        while (true) {
            CMDClient.showHelp();
            try {
                args = reader.nextLine().split(" ");
                long s = System.currentTimeMillis();
                DoipMessage repMsg = null;
                if (CMDClient.checkArgs(args)) {
                    switch (args[0]) {
                        case "hello": {
                            repMsg = client.hello(args[1]);
                            break;
                        }
                        case "list": {
                            repMsg = client.listOperations(args[1]);
                            break;
                        }
                        case "create": {
                            repMsg = client.create(args[1], CMDClient.getCreateDO());
                            break;
                        }
                        case "retrieve": {
                            String element = args.length > 3 ? args[2] : null;
                            repMsg = client.retrieve(args[1], element, true);
                            break;
                        }
                        case "update": {
                            DigitalObject tempDO = CMDClient.getUpdateDO(args[1]);
                            repMsg = client.update(args[1], tempDO);
                            break;
                        }
                        case "delete": {
                            repMsg = client.delete(args[1]);
                            break;
                        }
                        case "index": {
                            repMsg = client.create(args[1], CMDClient.getTestMetadata(args[2], args[3]));
                            break;
                        }
                        case "search": {
                            String registryID = args[1];
                            String query = args[2];
                            SearchParameter sp = SearchParameter.getDefaultParameter();
                            sp.query = query;
                            repMsg = client.search(sp, registryID);
                            break;
                        }
                        case "exit": {
                            System.exit(0);
                        }
                        default: {
                            CMDClient.showError();
                        }
                    }
                    System.out.println(args[0] + " done in " + (System.currentTimeMillis() - s) + "ms");
                    CMDClient.printResponse(repMsg);
                    continue;
                }
                CMDClient.showError();
                continue;
            }
            catch (Exception ex) {
                System.out.println("Exception happened during excution: " + ex.getMessage());
                continue;
            }
            break;
        }
    }

    private static void printResponse(DoipMessage repMsg) {
        if (repMsg == null) {
            logger.info("response: NULL!!");
            return;
        }
        logger.info("Response attributes: " + new String(repMsg.header.parameters.toByteArray()));
        logger.info("Response body: " + new String(repMsg.body.getDataAsJsonString()));
    }

    public static void showHelp() {
        System.out.println("usage:");
        System.out.println("       hello RepoID");
        System.out.println("       list DoID");
        System.out.println("       create RepoID");
        System.out.println("       retrieve DoID [elementId]");
        System.out.println("       update DoID");
        System.out.println("       delete DoID");
        System.out.println("       index registryID doID description");
        System.out.println("       search registryID keyword //avaiable registry 86.5000.470/doip.CloudTlsRegistry");
        System.out.println("       exit");
    }

    public static void showError() {
        System.out.println("Arguments error!");
    }

    public static boolean checkArgs(String[] args) {
        if (args.length < 1) {
            return true;
        }
        for (String arg : args) {
            if (!arg.equals("")) continue;
            return false;
        }
        switch (args[0]) {
            case "hello": 
            case "create": 
            case "update": 
            case "delete": 
            case "list": {
                if (args.length == 2) break;
                return false;
            }
            case "search": {
                if (args.length == 3) break;
                return false;
            }
            case "index": {
                if (args.length == 4) break;
                return false;
            }
            case "retrieve": {
                if (args.length >= 2 && args.length <= 3) break;
                return false;
            }
            case "exit": {
                return true;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static DigitalObject getCreateDO() {
        DigitalObject digitalObject = new DigitalObject("", DoType.DO);
        digitalObject.addAttribute("content", "helloWorld");
        Element e = new Element("hello", "String");
        String data = "world";
        for (int i = 0; i < 10; ++i) {
            data = data + " world";
        }
        e.setData(data.getBytes());
        digitalObject.addElements(e);
        logger.info("use default digital object, type: 0.Type/DO ");
        logger.info("DO attributes: " + DoipGson.getDoipGson().toJson(digitalObject.attributes));
        logger.info("Element: " + e.id + "; content: " + new String(e.getData()));
        return digitalObject;
    }

    public static DigitalObject getUpdateDO(String handle) {
        DigitalObject digitalObject = new DigitalObject(handle, DoType.DO);
        digitalObject.addAttribute("content", "hello updated");
        Element e = new Element("hello", "String");
        String data = "updated";
        for (int i = 0; i < 10; ++i) {
            data = data + " updated";
        }
        e.setData(data.getBytes());
        digitalObject.addElements(e);
        logger.info("use default digital object, type: 0.Type/DO ");
        logger.info("DO attributes: " + DoipGson.getDoipGson().toJson(digitalObject.attributes));
        logger.info("Element: " + e.id + "; content: " + new String(e.getData()));
        return digitalObject;
    }

    public static DigitalObject getTestMetadata(String doi, String description) {
        DigitalObject digitalObject = new DigitalObject(doi, DoType.Metadata);
        digitalObject.addAttribute("desc", description);
        logger.info("Create digital object, type: 0.Type/DO.Metadata ");
        logger.info("DO id: " + doi);
        logger.info("DO attributes: " + DoipGson.getDoipGson().toJson(digitalObject.attributes));
        return digitalObject;
    }

    static {
        logger = Logger.getLogger(CMDClient.class);
    }
}

