/*
 * Decompiled with CFR 0.152.
 */
package bdware.doip.app.devices;

import bdware.doip.app.Main;
import bdware.doip.app.Transport;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.apache.log4j.Logger;
import org.bdware.doip.application.client.DOAClient;
import org.bdware.doip.core.doipMessage.DoipMessage;
import org.bdware.doip.core.doipMessage.DoipResponseCode;
import org.bdware.doip.core.model.digitalObject.DigitalObject;
import org.bdware.doip.core.model.digitalObject.DoType;

public class Weight {
    public String id = "86.5000.470/do.vGW8zTfzD1";
    public String valueAPI;
    public DOAClient doaClient;
    public Transport httpHelper;
    public static Logger logger = Logger.getLogger(Main.class);

    public Weight(String controllerAddr, DOAClient doaClient, Transport httpHelper) {
        this.valueAPI = String.format("http://%s:6161/CMDManager?getMessage={\"pkgName\":\"gz.lifesense.weidong\",\"method\":\"getWeight\",\"arg\":\"\"}", controllerAddr);
        this.doaClient = doaClient;
        this.httpHelper = httpHelper;
    }

    public void Hello() {
        logger.info(String.format("weight value url: %s", this.valueAPI));
        String res = this.httpHelper.doGet(this.valueAPI);
        logger.info(String.format("weight value on start up:\n%s", res));
    }

    public void Update() {
        logger.info("try to update weight info");
        JsonObject jsonObject = null;
        String res = this.httpHelper.doGet(this.valueAPI);
        if (res != null) {
            try {
                jsonObject = new Gson().fromJson(res, JsonObject.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!jsonObject.has("errorCode")) {
                DigitalObject weightUpdateInfo = new DigitalObject(this.id, DoType.DO);
                weightUpdateInfo.attributes = jsonObject;
                try {
                    DoipMessage doipMessage = this.doaClient.update(weightUpdateInfo);
                    if (doipMessage.header.parameters.response.equals((Object)DoipResponseCode.Success)) {
                        logger.info("weight info update: success");
                    } else {
                        logger.error("weight info update: fail");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

