/*
 * Decompiled with CFR 0.152.
 */
package bdware.doip.app.devices;

import bdware.doip.app.Transport;
import org.apache.log4j.Logger;
import org.bdware.doip.application.client.DOAClient;
import org.bdware.doip.core.doipMessage.DoipMessage;

public class SmartFan {
    public String switchId = "86.5000.470/do.OLSZDm6Exq";
    public String shakeId = "86.5000.470/do.0GASNHPYuj";
    public DOAClient doaClient;
    public Transport httpHelper;
    public String deviceAddr;
    public String controllerAddr;
    public String token;
    public String switchMode = "off";
    public String shakeMode = "off";
    public static Logger logger = Logger.getLogger(SmartFan.class);

    public SmartFan(String controllerAddr, DOAClient doaClient, Transport httpHelper, String deviceAddr, String token) {
        this.controllerAddr = controllerAddr;
        this.deviceAddr = deviceAddr;
        this.token = token;
        this.doaClient = doaClient;
        this.httpHelper = httpHelper;
    }

    public void Hello() {
        logger.info("SmartFan start");
    }

    public void Update() {
        String success;
        String res;
        DoipMessage fanStat;
        logger.info("try to update switch mode");
        try {
            fanStat = this.doaClient.retrieve(this.switchId, null, true);
            String fanSwitchTmpSt = fanStat.body.getDataAsDigitalObject().attributes.get("current_mode").getAsString().toLowerCase();
            logger.info("last cycle switch set mode: " + this.switchMode);
            logger.info("current cycle switch set mode: " + fanSwitchTmpSt);
            if (!fanSwitchTmpSt.equals("on") && !fanSwitchTmpSt.equals("off")) {
                logger.error("invalid mode: " + fanSwitchTmpSt);
                return;
            }
            if (!fanSwitchTmpSt.equals(this.switchMode)) {
                this.switchMode = fanSwitchTmpSt;
                logger.debug("try to set desk lamp into work mode: " + this.switchMode);
                String fanSwitchAPI = String.format("http://%s:6161/CMDManager?getMessage={\"pkgName\":\"com.xiaomi.smarthome\",\"method\":\"setFanPower\",\"arg\":\"%s|%s|%s\"}", this.controllerAddr, this.deviceAddr, this.switchMode, this.token);
                logger.debug("send api command: " + fanSwitchAPI);
                res = this.httpHelper.doGet(fanSwitchAPI);
                success = "success";
                if (res != null) {
                    if (res.equals(success)) {
                        logger.info("update fan switch mode: success");
                    } else {
                        logger.error("update fan switch mode: fail, return msg: " + res);
                    }
                } else {
                    logger.error("update fan switch mode: fail, no response");
                }
            } else {
                logger.info("no need to update fan switch mode");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            fanStat = this.doaClient.retrieve(this.shakeId, null, true);
            String fanShakeTmpSt = fanStat.body.getDataAsDigitalObject().attributes.get("current_mode").getAsString().toLowerCase();
            logger.info("last cycle shake set mode: " + this.shakeMode);
            logger.info("current cycle shake set mode: " + fanShakeTmpSt);
            if (!fanShakeTmpSt.equals("on") && !fanShakeTmpSt.equals("off")) {
                logger.error("invalid mode: " + fanShakeTmpSt);
                return;
            }
            if (!fanShakeTmpSt.equals(this.shakeMode)) {
                this.shakeMode = fanShakeTmpSt;
                logger.debug("try to set desk lamp into work mode: " + this.shakeMode);
                String fanShakeAPI = String.format("http://%s:6161/CMDManager?getMessage={\"pkgName\":\"com.xiaomi.smarthome\",\"method\":\"shakeFanHead\",\"arg\":\"%s|%s|%s\"}", this.controllerAddr, this.deviceAddr, this.shakeMode, this.token);
                logger.debug("send api command: " + fanShakeAPI);
                res = this.httpHelper.doGet(fanShakeAPI);
                success = "success";
                if (res != null) {
                    if (res.equals(success)) {
                        logger.info("update fan shake mode: success");
                    } else {
                        logger.error("update fan shake mode: fail, return msg: " + res);
                    }
                } else {
                    logger.error("update fan shake mode: fail, no response");
                }
            } else {
                logger.info("no need to update fan shake mode");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

