package api

import "bdware.org/bdledger/pkg/common/log"

// API service config
type Conf struct {
	GRPC         GRPCConf `mapstructure:"grpc" json:"grpc"`                 // gRPC API config
	HTTP         HTTPConf `mapstructure:"http" json:"http"`                 // HTTP API config
	AccessTokens []string `mapstructure:"accessTokens" json:"accessTokens"` // Access tokens for authentication, disabled if empty
	RequestLog   bool     `mapstructure:"requestLog" json:"requestLog"`     // Enable API request logging
	// Verbosity level for the internal gRPC library logging, disabled if empty
	// Supported levels are: INFO, WARN, ERROR
	GRPCLogVerbosity log.Level `mapstructure:"grpcLogVerbosity" json:"grpcLogVerbosity"`
}

// gRPC API config
type GRPCConf struct {
	Enabled    bool   `mapstructure:"enabled" json:"enabled"`       // Enable gRPC API
	Addr       string `mapstructure:"addr" json:"addr"`             // gRPC API listening address, [IP]:PORT
	Reflection bool   `mapstructure:"reflection" json:"reflection"` // Enable gRPC server reflection service, only effective when gRPC API is enabled
}

// HTTP API config
type HTTPConf struct {
	Enabled bool   `mapstructure:"enabled" json:"enabled"` // Enable JSON API over HTTP
	Addr    string `mapstructure:"addr" json:"addr"`       // HTTP API listening address, [IP]:PORT, will use the same address as gRPC API if omitted
}

// MakeDefaultConf creates the default config.
func MakeDefaultConf() *Conf {
	return &Conf{
		GRPC: GRPCConf{
			Enabled:    true,
			Addr:       ":2401",
			Reflection: false,
		},
		HTTP: HTTPConf{
			Enabled: false,
			Addr:    "",
		},
		AccessTokens:     []string{},
		RequestLog:       true,
		GRPCLogVerbosity: log.WarnLevel,
	}
}
