// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package apipb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// QueryClient is the client API for Query service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type QueryClient interface {
	//*
	// Get a block identified by its hash
	// 查询哈希所指定的区块
	GetBlockByHash(ctx context.Context, in *GetBlockByHashRequest, opts ...grpc.CallOption) (*GetBlockByHashResponse, error)
	//*
	// Get blocks in a timestamp range
	// 查询时间范围内的区块
	// start_timestamp is required
	GetBlocks(ctx context.Context, in *BlocksRequest, opts ...grpc.CallOption) (*GetBlocksResponse, error)
	//*
	// Count all blocks in a ledger, or blocks in a timestamp range
	// 查询帐本中的所有区块数量，或时间范围内的区块数量
	CountBlocks(ctx context.Context, in *BlocksRequest, opts ...grpc.CallOption) (*CountBlocksResponse, error)
	//*
	// Get recent 'count' blocks (Only support IncludeTransactions=NONE for now)
	// 查询最新的n个区块
	GetRecentBlocks(ctx context.Context, in *RecentBlocksRequest, opts ...grpc.CallOption) (*GetBlocksResponse, error)
	//*
	// Get a transaction identified by its hash
	// 查询哈希所指定的事务
	GetTransactionByHash(ctx context.Context, in *GetTransactionByHashRequest, opts ...grpc.CallOption) (*GetTransactionByHashResponse, error)
	//*
	// Get a transaction identified by hash of the block it belongs to and its index inside the block
	// 查询所在区块的哈希与其在区块中的index所指定的事务
	GetTransactionByBlockHashAndIndex(ctx context.Context, in *GetTransactionByBlockHashAndIndexRequest, opts ...grpc.CallOption) (*GetTransactionByBlockHashAndIndexResponse, error)
	//*
	// Get transactions in a timestamp range
	// 查询时间范围内的事务
	GetTransactions(ctx context.Context, in *TransactionsRequest, opts ...grpc.CallOption) (*GetTransactionsResponse, error)
	//*
	// Count all transactions in a ledger, or transactions in a timestamp range
	// 查询帐本中的所有事务数量，或时间范围内的事务数量
	// start_timestamp is required
	CountTransactions(ctx context.Context, in *TransactionsRequest, opts ...grpc.CallOption) (*CountTransactionsResponse, error)
}

type queryClient struct {
	cc grpc.ClientConnInterface
}

func NewQueryClient(cc grpc.ClientConnInterface) QueryClient {
	return &queryClient{cc}
}

func (c *queryClient) GetBlockByHash(ctx context.Context, in *GetBlockByHashRequest, opts ...grpc.CallOption) (*GetBlockByHashResponse, error) {
	out := new(GetBlockByHashResponse)
	err := c.cc.Invoke(ctx, "/bdware.bdledger.api.Query/GetBlockByHash", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) GetBlocks(ctx context.Context, in *BlocksRequest, opts ...grpc.CallOption) (*GetBlocksResponse, error) {
	out := new(GetBlocksResponse)
	err := c.cc.Invoke(ctx, "/bdware.bdledger.api.Query/GetBlocks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) CountBlocks(ctx context.Context, in *BlocksRequest, opts ...grpc.CallOption) (*CountBlocksResponse, error) {
	out := new(CountBlocksResponse)
	err := c.cc.Invoke(ctx, "/bdware.bdledger.api.Query/CountBlocks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) GetRecentBlocks(ctx context.Context, in *RecentBlocksRequest, opts ...grpc.CallOption) (*GetBlocksResponse, error) {
	out := new(GetBlocksResponse)
	err := c.cc.Invoke(ctx, "/bdware.bdledger.api.Query/GetRecentBlocks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) GetTransactionByHash(ctx context.Context, in *GetTransactionByHashRequest, opts ...grpc.CallOption) (*GetTransactionByHashResponse, error) {
	out := new(GetTransactionByHashResponse)
	err := c.cc.Invoke(ctx, "/bdware.bdledger.api.Query/GetTransactionByHash", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) GetTransactionByBlockHashAndIndex(ctx context.Context, in *GetTransactionByBlockHashAndIndexRequest, opts ...grpc.CallOption) (*GetTransactionByBlockHashAndIndexResponse, error) {
	out := new(GetTransactionByBlockHashAndIndexResponse)
	err := c.cc.Invoke(ctx, "/bdware.bdledger.api.Query/GetTransactionByBlockHashAndIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) GetTransactions(ctx context.Context, in *TransactionsRequest, opts ...grpc.CallOption) (*GetTransactionsResponse, error) {
	out := new(GetTransactionsResponse)
	err := c.cc.Invoke(ctx, "/bdware.bdledger.api.Query/GetTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryClient) CountTransactions(ctx context.Context, in *TransactionsRequest, opts ...grpc.CallOption) (*CountTransactionsResponse, error) {
	out := new(CountTransactionsResponse)
	err := c.cc.Invoke(ctx, "/bdware.bdledger.api.Query/CountTransactions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// QueryServer is the server API for Query service.
type QueryServer interface {
	//*
	// Get a block identified by its hash
	// 查询哈希所指定的区块
	GetBlockByHash(context.Context, *GetBlockByHashRequest) (*GetBlockByHashResponse, error)
	//*
	// Get blocks in a timestamp range
	// 查询时间范围内的区块
	// start_timestamp is required
	GetBlocks(context.Context, *BlocksRequest) (*GetBlocksResponse, error)
	//*
	// Count all blocks in a ledger, or blocks in a timestamp range
	// 查询帐本中的所有区块数量，或时间范围内的区块数量
	CountBlocks(context.Context, *BlocksRequest) (*CountBlocksResponse, error)
	//*
	// Get recent 'count' blocks (Only support IncludeTransactions=NONE for now)
	// 查询最新的n个区块
	GetRecentBlocks(context.Context, *RecentBlocksRequest) (*GetBlocksResponse, error)
	//*
	// Get a transaction identified by its hash
	// 查询哈希所指定的事务
	GetTransactionByHash(context.Context, *GetTransactionByHashRequest) (*GetTransactionByHashResponse, error)
	//*
	// Get a transaction identified by hash of the block it belongs to and its index inside the block
	// 查询所在区块的哈希与其在区块中的index所指定的事务
	GetTransactionByBlockHashAndIndex(context.Context, *GetTransactionByBlockHashAndIndexRequest) (*GetTransactionByBlockHashAndIndexResponse, error)
	//*
	// Get transactions in a timestamp range
	// 查询时间范围内的事务
	GetTransactions(context.Context, *TransactionsRequest) (*GetTransactionsResponse, error)
	//*
	// Count all transactions in a ledger, or transactions in a timestamp range
	// 查询帐本中的所有事务数量，或时间范围内的事务数量
	// start_timestamp is required
	CountTransactions(context.Context, *TransactionsRequest) (*CountTransactionsResponse, error)
}

// UnimplementedQueryServer can be embedded to have forward compatible implementations.
type UnimplementedQueryServer struct {
}

func (*UnimplementedQueryServer) GetBlockByHash(context.Context, *GetBlockByHashRequest) (*GetBlockByHashResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBlockByHash not implemented")
}
func (*UnimplementedQueryServer) GetBlocks(context.Context, *BlocksRequest) (*GetBlocksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBlocks not implemented")
}
func (*UnimplementedQueryServer) CountBlocks(context.Context, *BlocksRequest) (*CountBlocksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountBlocks not implemented")
}
func (*UnimplementedQueryServer) GetRecentBlocks(context.Context, *RecentBlocksRequest) (*GetBlocksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRecentBlocks not implemented")
}
func (*UnimplementedQueryServer) GetTransactionByHash(context.Context, *GetTransactionByHashRequest) (*GetTransactionByHashResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTransactionByHash not implemented")
}
func (*UnimplementedQueryServer) GetTransactionByBlockHashAndIndex(context.Context, *GetTransactionByBlockHashAndIndexRequest) (*GetTransactionByBlockHashAndIndexResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTransactionByBlockHashAndIndex not implemented")
}
func (*UnimplementedQueryServer) GetTransactions(context.Context, *TransactionsRequest) (*GetTransactionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTransactions not implemented")
}
func (*UnimplementedQueryServer) CountTransactions(context.Context, *TransactionsRequest) (*CountTransactionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountTransactions not implemented")
}

func RegisterQueryServer(s *grpc.Server, srv QueryServer) {
	s.RegisterService(&_Query_serviceDesc, srv)
}

func _Query_GetBlockByHash_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBlockByHashRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).GetBlockByHash(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/bdware.bdledger.api.Query/GetBlockByHash",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).GetBlockByHash(ctx, req.(*GetBlockByHashRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_GetBlocks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BlocksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).GetBlocks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/bdware.bdledger.api.Query/GetBlocks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).GetBlocks(ctx, req.(*BlocksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_CountBlocks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BlocksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).CountBlocks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/bdware.bdledger.api.Query/CountBlocks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).CountBlocks(ctx, req.(*BlocksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_GetRecentBlocks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecentBlocksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).GetRecentBlocks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/bdware.bdledger.api.Query/GetRecentBlocks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).GetRecentBlocks(ctx, req.(*RecentBlocksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_GetTransactionByHash_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransactionByHashRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).GetTransactionByHash(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/bdware.bdledger.api.Query/GetTransactionByHash",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).GetTransactionByHash(ctx, req.(*GetTransactionByHashRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_GetTransactionByBlockHashAndIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransactionByBlockHashAndIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).GetTransactionByBlockHashAndIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/bdware.bdledger.api.Query/GetTransactionByBlockHashAndIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).GetTransactionByBlockHashAndIndex(ctx, req.(*GetTransactionByBlockHashAndIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_GetTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).GetTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/bdware.bdledger.api.Query/GetTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).GetTransactions(ctx, req.(*TransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Query_CountTransactions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransactionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServer).CountTransactions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/bdware.bdledger.api.Query/CountTransactions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServer).CountTransactions(ctx, req.(*TransactionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Query_serviceDesc = grpc.ServiceDesc{
	ServiceName: "bdware.bdledger.api.Query",
	HandlerType: (*QueryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetBlockByHash",
			Handler:    _Query_GetBlockByHash_Handler,
		},
		{
			MethodName: "GetBlocks",
			Handler:    _Query_GetBlocks_Handler,
		},
		{
			MethodName: "CountBlocks",
			Handler:    _Query_CountBlocks_Handler,
		},
		{
			MethodName: "GetRecentBlocks",
			Handler:    _Query_GetRecentBlocks_Handler,
		},
		{
			MethodName: "GetTransactionByHash",
			Handler:    _Query_GetTransactionByHash_Handler,
		},
		{
			MethodName: "GetTransactionByBlockHashAndIndex",
			Handler:    _Query_GetTransactionByBlockHashAndIndex_Handler,
		},
		{
			MethodName: "GetTransactions",
			Handler:    _Query_GetTransactions_Handler,
		},
		{
			MethodName: "CountTransactions",
			Handler:    _Query_CountTransactions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "bdware/bdledger/api/query.proto",
}
